/*
 * Decompiled with CFR 0.152.
 */
package ferro2000.immersivetech.common.integration;

import blusunrize.immersiveengineering.common.util.IELogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ITIntegrationModule {
    public static HashMap<String, Class<? extends ITIntegrationModule>> moduleClasses = new HashMap();
    public static Set<ITIntegrationModule> modules = new HashSet<ITIntegrationModule>();
    public static Consumer<Object> jeiAddFunc = o -> {};
    public static Consumer<Object> jeiRemoveFunc = o -> {};
    public static boolean serverStartingDone = false;

    public static void doModulesPreInit() {
        for (Map.Entry<String, Class<? extends ITIntegrationModule>> e : moduleClasses.entrySet()) {
            if (!Loader.isModLoaded((String)e.getKey())) continue;
            try {
                ITIntegrationModule m = e.getValue().newInstance();
                modules.add(m);
                m.preInit();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + e.getKey() + " could not be preInitialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesInit() {
        for (ITIntegrationModule compat : modules) {
            try {
                compat.init();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not be initialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesPostInit() {
        for (ITIntegrationModule compat : modules) {
            try {
                compat.postInit();
            }
            catch (Exception exception) {
                IELogger.logger.error("Compat module for " + compat + " could not be postInitialized. Report this and include the error message below!", (Throwable)exception);
            }
        }
    }

    public static void doModulesLoadComplete() {
        if (!serverStartingDone) {
            serverStartingDone = true;
            for (ITIntegrationModule compat : modules) {
                try {
                    compat.loadComplete();
                }
                catch (Exception exception) {
                    IELogger.logger.error("Compat module for " + compat + " could not be initialized. Report this and include the error message below!", (Throwable)exception);
                }
            }
        }
    }

    public abstract void preInit();

    public abstract void init();

    public abstract void postInit();

    public void loadComplete() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPreInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPostInit() {
    }
}

