/*
 * Decompiled with CFR 0.152.
 */
package ferro2000.immersivetech.api.craftings;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class DistillerRecipes
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public static float chance;
    public final FluidStack fluidOutput;
    public final FluidStack input;
    public final ItemStack itemOutput;
    public static ArrayList<DistillerRecipes> recipeList;
    int totalProcessTime;
    int totalProcessEnergy;

    public DistillerRecipes(FluidStack fluidOutput, FluidStack input, ItemStack itemOutput, int energy, int time, float chance) {
        this.fluidOutput = fluidOutput;
        this.input = input;
        this.itemOutput = itemOutput;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        DistillerRecipes.chance = chance;
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.input});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
        this.outputList = ListUtils.fromItem((ItemStack)this.itemOutput);
    }

    public static DistillerRecipes addRecipe(FluidStack fluidOutput, FluidStack input, ItemStack itemOutput, int energy, int time, float chance) {
        DistillerRecipes r = new DistillerRecipes(fluidOutput, input, itemOutput, energy, time, chance);
        recipeList.add(r);
        return r;
    }

    public static DistillerRecipes findRecipe(FluidStack input) {
        for (DistillerRecipes recipe : recipeList) {
            if (input == null || recipe.input == null || !input.containsFluid(recipe.input)) continue;
            return recipe;
        }
        return null;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static DistillerRecipes loadFromNBT(NBTTagCompound nbt) {
        FluidStack input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("input"));
        return DistillerRecipes.findRecipe(input);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        if (tile.func_145831_w().field_73012_v.nextFloat() <= chance) {
            return this.getItemOutputs();
        }
        return ListUtils.fromItems((ItemStack[])new ItemStack[0]);
    }

    static {
        recipeList = new ArrayList();
    }
}

