/*
 * Decompiled with CFR 0.152.
 */
package ferro2000.immersivetech.api;

import ferro2000.immersivetech.api.client.MechanicalEnergyAnimation;
import ferro2000.immersivetech.api.energy.MechanicalEnergy;
import ferro2000.immersivetech.common.blocks.ITBlockInterface;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntityAlternator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ITUtils {
    public static double[] smartBoundingBox(double A, double B, double C, double D, double minY, double maxY, EnumFacing fl, EnumFacing fw) {
        double[] boundingArray = new double[6];
        boundingArray[0] = fl == EnumFacing.WEST ? A : (fl == EnumFacing.EAST ? B : (fw == EnumFacing.EAST ? C : D));
        boundingArray[1] = minY;
        double d = fl == EnumFacing.NORTH ? A : (fl == EnumFacing.SOUTH ? B : (boundingArray[2] = fw == EnumFacing.SOUTH ? C : D));
        boundingArray[3] = fl == EnumFacing.EAST ? 1.0 - A : (fl == EnumFacing.WEST ? 1.0 - B : (fw == EnumFacing.EAST ? 1.0 - D : 1.0 - C));
        boundingArray[4] = maxY;
        boundingArray[5] = fl == EnumFacing.SOUTH ? 1.0 - A : (fl == EnumFacing.NORTH ? 1.0 - B : (fw == EnumFacing.SOUTH ? 1.0 - D : 1.0 - C));
        return boundingArray;
    }

    public static boolean checkMechanicalEnergyTransmitter(World world, BlockPos startPos) {
        EnumFacing inputFacing;
        BlockPos pos;
        TileEntity tileTransmitter;
        TileEntity tile = world.func_175625_s(startPos);
        return tile instanceof ITBlockInterface.IMechanicalEnergy && ((ITBlockInterface.IMechanicalEnergy)tile).isMechanicalEnergyReceiver() && (tileTransmitter = world.func_175625_s(pos = startPos.func_177967_a(inputFacing = ((ITBlockInterface.IMechanicalEnergy)tile).getMechanicalEnergyInputFacing(), ((ITBlockInterface.IMechanicalEnergy)tile).inputToCenterDistance() + 1))) instanceof ITBlockInterface.IMechanicalEnergy && ((ITBlockInterface.IMechanicalEnergy)tileTransmitter).isMechanicalEnergyTransmitter() && ((ITBlockInterface.IMechanicalEnergy)tileTransmitter).getMechanicalEnergyOutputFacing() == inputFacing.func_176734_d();
    }

    public static boolean checkMechanicalEnergyReceiver(World world, BlockPos startPos) {
        EnumFacing outputFacing;
        BlockPos pos;
        TileEntity tileReceiver;
        TileEntity tile = world.func_175625_s(startPos);
        return tile instanceof ITBlockInterface.IMechanicalEnergy && ((ITBlockInterface.IMechanicalEnergy)tile).isMechanicalEnergyTransmitter() && (tileReceiver = world.func_175625_s(pos = startPos.func_177967_a(outputFacing = ((ITBlockInterface.IMechanicalEnergy)tile).getMechanicalEnergyOutputFacing(), ((ITBlockInterface.IMechanicalEnergy)tile).outputToCenterDistance() + 1))) instanceof ITBlockInterface.IMechanicalEnergy && ((ITBlockInterface.IMechanicalEnergy)tileReceiver).isMechanicalEnergyReceiver() && ((ITBlockInterface.IMechanicalEnergy)tileReceiver).getMechanicalEnergyInputFacing() == outputFacing.func_176734_d();
    }

    public static MechanicalEnergy getMechanicalEnergy(World world, BlockPos startPos) {
        TileEntity tileInfo;
        TileEntity tile = world.func_175625_s(startPos);
        EnumFacing inputFacing = ((ITBlockInterface.IMechanicalEnergy)tile).getMechanicalEnergyInputFacing();
        BlockPos pos = startPos.func_177967_a(inputFacing, ((ITBlockInterface.IMechanicalEnergy)tile).inputToCenterDistance() + 1);
        TileEntity tileTransmitter = world.func_175625_s(pos.func_177967_a(inputFacing, ((ITBlockInterface.IMechanicalEnergy)(tileInfo = world.func_175625_s(pos))).outputToCenterDistance()));
        if (tileTransmitter instanceof ITBlockInterface.IMechanicalEnergy) {
            return ((ITBlockInterface.IMechanicalEnergy)tileTransmitter).getEnergy();
        }
        return new MechanicalEnergy(0, 0, 0);
    }

    public static boolean checkAlternatorStatus(World world, BlockPos startPos) {
        TileEntity tileInfo;
        TileEntity tile = world.func_175625_s(startPos);
        EnumFacing outputFacing = ((ITBlockInterface.IMechanicalEnergy)tile).getMechanicalEnergyOutputFacing();
        BlockPos pos = startPos.func_177967_a(outputFacing, ((ITBlockInterface.IMechanicalEnergy)tile).outputToCenterDistance() + 1);
        TileEntity tileReceiver = world.func_175625_s(pos.func_177967_a(outputFacing, ((ITBlockInterface.IMechanicalEnergy)(tileInfo = world.func_175625_s(pos))).inputToCenterDistance()));
        return tileReceiver instanceof TileEntityAlternator && ((TileEntityAlternator)tileReceiver).canRunMechanicalEnergy();
    }

    public static MechanicalEnergyAnimation setRotationAngle(MechanicalEnergyAnimation animation, boolean active) {
        if (active || animation.getAnimationFadeIn() > 0 || animation.getAnimationFadeOut() > 0) {
            int fadeIn = animation.getAnimationFadeIn();
            int fadeOut = animation.getAnimationFadeOut();
            float base = 18.0f;
            float step = active ? base : 0.0f;
            float rotation = animation.getAnimationRotation();
            if (animation.getAnimationFadeIn() > 0) {
                step -= (float)animation.getAnimationFadeIn() / 80.0f * base;
                --fadeIn;
            }
            if (animation.getAnimationFadeOut() > 0) {
                step += (float)animation.getAnimationFadeOut() / 80.0f * base;
                --fadeOut;
            }
            rotation += step;
            return new MechanicalEnergyAnimation(fadeIn, fadeOut, rotation %= 360.0f, step);
        }
        return new MechanicalEnergyAnimation(0, 0, animation.getAnimationRotation(), 0.0f);
    }

    public static MechanicalEnergyAnimation getMechanicalEnergyAnimation(World world, BlockPos startPos) {
        TileEntity tileInfo;
        TileEntity tile = world.func_175625_s(startPos);
        EnumFacing inputFacing = ((ITBlockInterface.IMechanicalEnergy)tile).getMechanicalEnergyInputFacing();
        BlockPos pos = startPos.func_177967_a(inputFacing, ((ITBlockInterface.IMechanicalEnergy)tile).inputToCenterDistance() + 1);
        TileEntity tileTransmitter = world.func_175625_s(pos.func_177967_a(inputFacing, ((ITBlockInterface.IMechanicalEnergy)(tileInfo = world.func_175625_s(pos))).outputToCenterDistance()));
        if (tileTransmitter instanceof ITBlockInterface.IMechanicalEnergy) {
            return ((ITBlockInterface.IMechanicalEnergy)tileTransmitter).getAnimation();
        }
        return new MechanicalEnergyAnimation();
    }

    public static EnumFacing getInputFacing(World world, BlockPos startPos) {
        TileEntity tile = world.func_175625_s(startPos);
        for (EnumFacing f : EnumFacing.field_176754_o) {
            BlockPos pos = startPos.func_177967_a(f, 1);
            TileEntity tileTransmitter = world.func_175625_s(pos);
            if (!(tileTransmitter instanceof ITBlockInterface.IMechanicalEnergy) || !((ITBlockInterface.IMechanicalEnergy)tileTransmitter).isMechanicalEnergyTransmitter() || ((ITBlockInterface.IMechanicalEnergy)tileTransmitter).getMechanicalEnergyOutputFacing() != f.func_176734_d()) continue;
            return f;
        }
        return null;
    }
}

