/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.blocks.tiles;

import com.corwinjv.mobtotems.TotemHelper;
import com.corwinjv.mobtotems.blocks.SacredLightBlock;
import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.Modifiers;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.TotemLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.base.ModMultiblockInventoryTileEntity;
import com.corwinjv.mobtotems.gui.OfferingBoxContainer;
import com.corwinjv.mobtotems.interfaces.IChargeableTileEntity;
import com.corwinjv.mobtotems.interfaces.IMultiblock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class OfferingBoxTileEntity
extends ModMultiblockInventoryTileEntity<TotemType>
implements IChargeableTileEntity {
    public static final int MAX_CHARGE = 1000;
    private static int INVENTORY_SIZE = 9;
    private static int FUELED_INCR_AMOUNT = 1000;
    private static int TICK_DECR_AMOUNT = 1;
    private static final String CHARGE_LEVEL = "CHARGE_LEVEL";
    private static final String SLAVE_TYPES_COPY = "SLAVE_TYPES_COPY";
    private int chargeLevel = 0;
    private List<TotemType> slaveTypesCopy = new ArrayList<TotemType>();

    public void func_73660_a() {
        long worldTime = this.field_145850_b.func_82737_E();
        if (!this.field_145850_b.field_72995_K && this.getIsMaster() && worldTime % 20L == 0L) {
            if (this.getChargeLevel() + FUELED_INCR_AMOUNT <= 1000) {
                BlockPos lastSlave;
                Block blockToCheck;
                List<ItemStack> cost = new ArrayList<ItemStack>();
                for (BlockPos slavePos : this.getSlaves()) {
                    TileEntity totemTe = this.field_145850_b.func_175625_s(slavePos);
                    if (!(totemTe instanceof TotemTileEntity)) continue;
                    List<ItemStack> totemCost = TotemHelper.getCostForTotemType(((TotemTileEntity)totemTe).getType());
                    for (ItemStack stack : totemCost) {
                        cost.add(stack);
                    }
                }
                cost = this.condenseCostStacks(cost);
                ArrayList<ItemStack> costCopy = new ArrayList<ItemStack>(cost);
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    for (int j = costCopy.size() - 1; j >= 0; --j) {
                        ItemStack costStack = new ItemStack(((ItemStack)costCopy.get(j)).func_77973_b(), ((ItemStack)costCopy.get(j)).func_190916_E(), ((ItemStack)costCopy.get(j)).func_77960_j());
                        if (costStack.func_77973_b() != this.func_70301_a(i).func_77973_b()) continue;
                        if (this.func_70301_a(i).func_190916_E() >= costStack.func_190916_E()) {
                            costCopy.remove(j);
                            continue;
                        }
                        if (this.func_70301_a(i).func_190916_E() >= costStack.func_190916_E()) continue;
                        costStack.func_190920_e(costStack.func_190916_E() - this.func_70301_a(i).func_190916_E());
                        costCopy.set(j, costStack);
                        if (costStack.func_190916_E() != 0) continue;
                        costCopy.remove(j);
                    }
                }
                boolean hasSacredLight = false;
                List<BlockPos> slaves = this.getSlaves();
                if (slaves.size() > 0 && (blockToCheck = this.field_145850_b.func_180495_p(new BlockPos((lastSlave = this.getSlaves().get(this.getSlaves().size() - 1)).func_177958_n(), lastSlave.func_177956_o() + 1, lastSlave.func_177952_p())).func_177230_c()) instanceof SacredLightBlock) {
                    hasSacredLight = true;
                }
                if (costCopy.size() == 0) {
                    costCopy = new ArrayList<ItemStack>(cost);
                    for (int i = this.func_70302_i_() - 1; i >= 0; --i) {
                        for (int j = costCopy.size() - 1; j >= 0; --j) {
                            ItemStack costStack = (ItemStack)costCopy.get(j);
                            if (costStack.func_77973_b() != this.func_70301_a(i).func_77973_b()) continue;
                            if (this.func_70301_a(i).func_190916_E() <= costStack.func_190916_E()) {
                                costStack.func_190920_e(costStack.func_190916_E() - this.func_70301_a(i).func_190916_E());
                                if (costStack.func_190916_E() == 0) {
                                    costCopy.remove(costStack);
                                }
                                this.func_70304_b(i);
                                continue;
                            }
                            if (this.func_70301_a(i).func_190916_E() <= costStack.func_190916_E()) continue;
                            this.func_70298_a(i, costStack.func_190916_E());
                            costCopy.remove(j);
                        }
                    }
                    int blankTotemCount = 0;
                    for (TotemType type : this.getSlaveTypes()) {
                        if (!type.equals((Object)TotemType.NONE)) continue;
                        ++blankTotemCount;
                    }
                    if (blankTotemCount < this.getSlaveTypes().size()) {
                        this.incrementChargeLevel(FUELED_INCR_AMOUNT);
                    }
                }
                if (hasSacredLight) {
                    this.incrementChargeLevel(FUELED_INCR_AMOUNT);
                }
            }
            this.decrementChargeLevel(TICK_DECR_AMOUNT);
        }
        if (!this.field_145850_b.field_72995_K && this.getIsMaster() && this.getChargeLevel() > 0) {
            this.performChargeEffect(worldTime);
        }
    }

    private List<ItemStack> condenseCostStacks(List<ItemStack> costStacks) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : costStacks) {
            boolean containsItem = false;
            for (ItemStack retStack : ret) {
                if (!stack.func_77973_b().equals(retStack.func_77973_b())) continue;
                retStack.func_190920_e(retStack.func_190916_E() + stack.func_190916_E());
                containsItem = true;
            }
            if (containsItem) continue;
            ret.add(stack);
        }
        return ret;
    }

    private void performChargeEffect(long tick) {
        List<TotemType> slaveTypes = this.getSlaveTypes();
        ArrayList<TotemType> effects = new ArrayList<TotemType>();
        ArrayList<TotemType> modifiers = new ArrayList<TotemType>();
        TotemHelper.sortEffectsAndModifiers(slaveTypes, effects, modifiers);
        for (TotemType type : effects) {
            TotemLogic logic;
            Modifiers mods = new Modifiers();
            for (TotemType modifierType : modifiers) {
                logic = TotemHelper.getTotemLogic(modifierType);
                if (logic == null) continue;
                mods = logic.adjustModifiers(mods);
            }
            int baseEffectTick = 40;
            int baseSpeedEffect = -10;
            if ((float)tick % ((float)baseEffectTick + (float)baseSpeedEffect * mods.speed) != 0.0f || (logic = TotemHelper.getTotemLogic(type)) == null) continue;
            logic.performEffect(this.field_145850_b, this.field_174879_c, mods);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74768_a(CHARGE_LEVEL, this.chargeLevel);
        int[] slaveTypesArr = new int[this.slaveTypesCopy.size()];
        for (int i = 0; i < this.slaveTypesCopy.size(); ++i) {
            slaveTypesArr[i] = this.slaveTypesCopy.get(i).ordinal();
        }
        nbt.func_74783_a(SLAVE_TYPES_COPY, slaveTypesArr);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.chargeLevel = nbt.func_74762_e(CHARGE_LEVEL);
        int[] slaveTypesArr = nbt.func_74759_k(SLAVE_TYPES_COPY);
        this.slaveTypesCopy.clear();
        for (int i = 0; i < slaveTypesArr.length; ++i) {
            this.slaveTypesCopy.add(TotemType.fromMeta(slaveTypesArr[i]));
        }
    }

    @Override
    public int getMaxChargeLevel() {
        return 1000;
    }

    @Override
    public int getChargeLevel() {
        return this.chargeLevel;
    }

    @Override
    public void setChargeLevel(int chargeLevel) {
        this.chargeLevel = chargeLevel;
        this.func_70296_d();
    }

    @Override
    public void decrementChargeLevel(int amount) {
        this.chargeLevel -= amount;
        if (this.chargeLevel < 0) {
            this.chargeLevel = 0;
        }
        this.func_70296_d();
    }

    @Override
    public void incrementChargeLevel(int amount) {
        this.chargeLevel += amount;
        if (this.chargeLevel > 1000) {
            this.chargeLevel = 1000;
        }
        this.func_70296_d();
    }

    @Override
    public void verifyMultiblock() {
        TotemTileEntity firstSlave = null;
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            Vec3i dirVec = direction.func_176730_m();
            BlockPos posToCheck = new BlockPos(this.func_174877_v().func_177958_n() + dirVec.func_177958_n(), this.func_174877_v().func_177956_o() + dirVec.func_177956_o(), this.func_174877_v().func_177952_p() + dirVec.func_177952_p());
            TileEntity te = this.field_145850_b.func_175625_s(posToCheck);
            if (te == null || !(te instanceof TotemTileEntity)) continue;
            firstSlave = (TotemTileEntity)te;
            break;
        }
        List<BlockPos> tmpSlaves = new ArrayList<BlockPos>();
        if (firstSlave != null) {
            tmpSlaves = TotemHelper.checkForSlaveAboveRecursively(this.field_145850_b, firstSlave.func_174877_v(), 3);
        }
        this.isMaster = false;
        if (this.areSlavesValid(tmpSlaves)) {
            this.setSlaves(tmpSlaves);
            this.isMaster = true;
        } else {
            this.setSlaves(new ArrayList<BlockPos>());
        }
        this.setIsMaster(this.isMaster);
        for (BlockPos slavePos : this.getSlaves()) {
            TileEntity te = this.field_145850_b.func_175625_s(slavePos);
            if (te == null || !(te instanceof TotemTileEntity)) continue;
            ((TotemTileEntity)te).setMaster(this);
        }
        if (!this.slaveTypesCopy.equals(this.getSlaveTypes()) || !this.getIsMaster()) {
            this.setChargeLevel(0);
            this.slaveTypesCopy.clear();
            for (TotemType type : this.getSlaveTypes()) {
                this.slaveTypesCopy.add(type);
            }
        }
    }

    private boolean areSlavesValid(List<BlockPos> tmpSlaves) {
        boolean slavesAreValid = true;
        if (tmpSlaves.size() < 2) {
            return false;
        }
        for (BlockPos slavePos : tmpSlaves) {
            TileEntity master;
            TileEntity te = this.field_145850_b.func_175625_s(slavePos);
            if (te == null || !(te instanceof TotemTileEntity) || (master = (TileEntity)((TotemTileEntity)te).getMaster()) == null || master.func_174877_v() == this.func_174877_v()) continue;
            slavesAreValid = false;
            break;
        }
        return slavesAreValid;
    }

    @Override
    public void invalidateSlaves() {
        super.invalidateSlaves();
        this.setChargeLevel(0);
    }

    @Override
    public List<BlockPos> getSlaves() {
        return this.slaves;
    }

    @Override
    public List<TotemType> getSlaveTypes() {
        ArrayList<TotemType> slaveTypes = new ArrayList<TotemType>();
        for (BlockPos slavePos : this.slaves) {
            TileEntity te = this.field_145850_b.func_175625_s(slavePos);
            if (!(te instanceof TotemTileEntity)) continue;
            slaveTypes.add(((TotemTileEntity)te).getType());
        }
        return slaveTypes;
    }

    public List<TotemType> getSlaveTypesCopy() {
        return this.slaveTypesCopy;
    }

    public void setSlaveTypesCopy(List<TotemType> slaveTypesCopy) {
        this.slaveTypesCopy = slaveTypesCopy;
        this.func_70296_d();
    }

    @Override
    public TotemType getType() {
        return TotemType.NONE;
    }

    @Override
    public void setType(TotemType type) {
    }

    @Override
    public void setMaster(IMultiblock<TotemType> master) {
    }

    @Override
    public IMultiblock<TotemType> getMaster() {
        return null;
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer playerIn) {
        return new OfferingBoxContainer(playerInventory, (IInventory)this);
    }

    @Nonnull
    public String func_174875_k() {
        return "mobtotems:offering_box";
    }

    public int func_70302_i_() {
        return INVENTORY_SIZE;
    }

    public int func_70297_j_() {
        return 9;
    }

    @Nonnull
    public String func_70005_c_() {
        return "container.offering_box";
    }

    @Override
    protected int getUsableDistance() {
        return 3;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            default: 
        }
        return this.chargeLevel;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            default: 
        }
        this.setChargeLevel(value);
    }

    @Override
    public int func_174890_g() {
        return 1;
    }
}

