/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.compressed;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.OverloadedCreativeTabs;
import com.cjm721.overloaded.block.ModBlock;
import com.cjm721.overloaded.client.render.dynamic.compressed.block.CompressedBlockAssets;
import com.cjm721.overloaded.config.compressed.CompressedEntry;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockCompressed
extends ModBlock {
    private static final PropertyInteger compressionProperty = PropertyInteger.func_177719_a((String)"compression", (int)0, (int)15);
    private final String registryName;
    private final String unlocalizedName;
    private Block baseBlock;
    private final int maxCompressionAmount;
    private final float hardnessMultiplier;
    private final boolean recipeEnabled;
    private final CompressedEntry entry;

    BlockCompressed(@Nonnull String registryName, @Nonnull String unlocalizedName, CompressedEntry entry) {
        super(Material.field_151579_a);
        this.registryName = registryName;
        this.unlocalizedName = unlocalizedName;
        this.entry = entry;
        this.maxCompressionAmount = entry.depth;
        this.hardnessMultiplier = entry.hardnessMultiplier;
        this.recipeEnabled = entry.recipeEnabled;
        this.func_149647_a(OverloadedCreativeTabs.COMPRESSED_BLOCKS);
    }

    @Override
    public void baseInit() {
        this.setRegistryName(this.registryName);
        this.func_149663_c(this.unlocalizedName);
    }

    public boolean baseBlockInit() {
        IForgeRegistry registry = GameRegistry.findRegistry(Block.class);
        this.baseBlock = (Block)registry.getValue(new ResourceLocation(this.entry.baseRegistryName));
        if (this.baseBlock == null) {
            Overloaded.logger.error("Invalid Compressed config entry: Base Block does not exist. %s", (Object)this.entry.baseRegistryName);
            return false;
        }
        Field blockMaterialField = ReflectionHelper.findField(Block.class, (String[])new String[]{"material", "field_149764_J"});
        Field blockMapColorIn = ReflectionHelper.findField(Block.class, (String[])new String[]{"blockMapColor", "field_181083_K"});
        blockMaterialField.setAccessible(true);
        blockMapColorIn.setAccessible(true);
        try {
            blockMaterialField.set(this, blockMaterialField.get(this.baseBlock));
            blockMapColorIn.set(this, blockMapColorIn.get(this.baseBlock));
        }
        catch (IllegalAccessException e) {
            Overloaded.logger.error("Unable to get material and color of base block.", (Throwable)e);
            return false;
        }
        this.func_149672_a(this.baseBlock.func_185467_w());
        String harvestTool = this.baseBlock.getHarvestTool(this.baseBlock.func_176223_P());
        if (harvestTool != null) {
            this.setHarvestLevel(harvestTool, this.baseBlock.getHarvestLevel(this.baseBlock.func_176223_P()));
        }
        return true;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int meta = 0; meta < this.maxCompressionAmount; ++meta) {
            items.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, meta));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{compressionProperty}).build();
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)compressionProperty);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)compressionProperty, (Comparable)Integer.valueOf(meta));
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (this.baseBlock == null) {
            return 0.0f;
        }
        int compression = (Integer)blockState.func_177229_b((IProperty)compressionProperty);
        float hardness = this.baseBlock.func_176223_P().func_185887_b(worldIn, pos);
        for (int i = 0; i <= compression; ++i) {
            hardness *= this.hardnessMultiplier;
        }
        return hardness;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.func_176195_g(world.func_180495_p(pos), world, pos) / 5.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, ITooltipFlag advanced) {
        if (Overloaded.cachedConfig.compressedConfig.showHardness) {
            tooltip.add(String.format("Hardness: %.0f", Float.valueOf(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()).func_185887_b(null, null))));
        }
        super.func_190948_a(stack, world, tooltip, advanced);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        final HashMap<IBlockState, ModelResourceLocation> states = new HashMap<IBlockState, ModelResourceLocation>();
        for (int meta = 0; meta < this.maxCompressionAmount; ++meta) {
            ResourceLocation rl = new ResourceLocation(this.getRegistryName().func_110624_b(), this.getRegistryName().func_110623_a() + meta);
            CompressedBlockAssets.addToTextureQueue(new CompressedBlockAssets.CompressedResourceLocation(this.entry.texturePath, rl, meta + 1));
            ModelResourceLocation ml = new ModelResourceLocation(rl, "normal");
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)meta, (ModelResourceLocation)ml);
            states.put(this.func_176203_a(meta), ml);
        }
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new IStateMapper(){

            @Nonnull
            public Map<IBlockState, ModelResourceLocation> func_178130_a(@Nonnull Block blockIn) {
                return states;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    private ModelResourceLocation getBaseModelLocation() {
        return new ModelResourceLocation(this.baseBlock.getRegistryName(), null);
    }

    @Nonnull
    public String func_149732_F() {
        return this.baseBlock.func_149732_F();
    }

    public int getMaxCompression() {
        return this.maxCompressionAmount;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    public Block getBaseBlock() {
        if (this.baseBlock == null) {
            return Blocks.field_150350_a;
        }
        return this.baseBlock;
    }

    public boolean isRecipeEnabled() {
        return this.recipeEnabled;
    }

    public int getBaseMeta() {
        return this.entry.meta;
    }
}

