/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util.world;

import com.google.common.io.Files;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfig;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;

public class WorldFileUtils {
    private static final String JED_LEVEL_FILENAME = "jed_level.dat";
    private static final FileFilter FILE_FILTER_NO_LEVEL = new FileFilter(){

        @Override
        public boolean accept(File name) {
            return !name.getName().equals("level.dat");
        }
    };

    @Nullable
    public static File getWorldDirectory(World world) {
        IChunkProvider chunkProvider = world.func_72863_F();
        if (chunkProvider instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)chunkProvider;
            IChunkLoader chunkLoader = chunkProviderServer.field_73247_e;
            if (chunkLoader instanceof AnvilChunkLoader) {
                return ((AnvilChunkLoader)chunkLoader).field_75825_d;
            }
            return null;
        }
        return WorldFileUtils.getWorldDirectoryDirectly(world, true);
    }

    private static File getWorldDirectoryDirectly(World world, boolean mkDirs) {
        File mainWorldDir;
        File dimensionDir = mainWorldDir = world.func_72860_G().func_75765_b();
        String dimensionDirName = world.field_73011_w.getSaveFolder();
        if (dimensionDirName != null) {
            dimensionDir = new File(mainWorldDir, dimensionDirName);
            if (mkDirs) {
                dimensionDir.mkdirs();
            }
        }
        return dimensionDir;
    }

    public static boolean jedLevelFileExists(World world) {
        File worldDir = WorldFileUtils.getWorldDirectory(world);
        if (worldDir != null) {
            File levelFile = new File(worldDir, JED_LEVEL_FILENAME);
            return levelFile.exists() && levelFile.isFile();
        }
        return false;
    }

    public static void copyTemplateWorldIfApplicable(World world) {
        int dimension = world.field_73011_w.getDimension();
        if (dimension != 0) {
            File dimensionDir = WorldFileUtils.getWorldDirectoryDirectly(world, false);
            WorldFileUtils.copyTemplateWorldIfApplicable(dimension, dimensionDir);
        }
    }

    public static void copyTemplateWorldIfApplicable(int dimension, File dimensionDir) {
        DimensionConfigEntry entry = DimensionConfig.instance().getDimensionConfigFor(dimension);
        if (entry != null && entry.getWorldTemplate() != null && WorldFileUtils.isNewWorld(dimensionDir)) {
            File templateWorld = new File(new File(Configs.getConfigDir(), "world_templates"), entry.getWorldTemplate());
            if (templateWorld.exists() && templateWorld.isDirectory() && templateWorld.canRead()) {
                try {
                    File levelFile = new File(templateWorld, "level.dat");
                    boolean hasLevelFile = levelFile.exists() && levelFile.isFile() && levelFile.canRead();
                    boolean worldUtilsPresent = Loader.isModLoaded((String)"worldutils");
                    if (dimension == 0 && hasLevelFile || dimension != 0 && worldUtilsPresent) {
                        JustEnoughDimensions.logInfo("Copying a template world from '{}' to '{}'", templateWorld.getAbsolutePath(), dimensionDir.getAbsolutePath());
                        FileUtils.copyDirectory((File)templateWorld, (File)dimensionDir, (FileFilter)FILE_FILTER_NO_LEVEL, (boolean)true);
                        if (hasLevelFile && dimension == 0) {
                            Files.copy((File)levelFile, (File)new File(dimensionDir, "level.dat"));
                        }
                    } else if (dimension == 0 && !hasLevelFile) {
                        JustEnoughDimensions.logger.warn("Template world '{}' doesn't have the level.dat file (required for the ID map)", (Object)templateWorld.getAbsolutePath());
                    } else if (dimension != 0 && !worldUtilsPresent) {
                        JustEnoughDimensions.logger.warn("Template world '{}' can't be block-ID-converted because the World Utils mod isn't present", (Object)templateWorld.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    JustEnoughDimensions.logger.warn("Failed to copy a template world from '{}' to '{}'", (Object)templateWorld.getAbsolutePath(), (Object)dimensionDir.getAbsolutePath());
                }
            } else {
                JustEnoughDimensions.logger.warn("Template world '{}' doesn't exist or is not readable", (Object)templateWorld.getAbsolutePath());
            }
        }
    }

    public static void createTemporaryWorldMarkerIfApplicable(World world) {
        File jedDataDir;
        File markerFile;
        File worldDir;
        int dimension = world.field_73011_w.getDimension();
        DimensionConfigEntry entry = DimensionConfig.instance().getDimensionConfigFor(dimension);
        if (entry != null && entry.isTemporaryDimension() && WorldFileUtils.isNewWorld(worldDir = WorldFileUtils.getWorldDirectoryDirectly(world, false)) && !(markerFile = WorldFileUtils.getTemporaryDimensionMarkerFile(jedDataDir = WorldFileUtils.getWorldJEDDataDirectory(worldDir))).exists()) {
            try {
                JustEnoughDimensions.logInfo("Creating a temporary dimension marker file '{}'", markerFile.getAbsolutePath());
                jedDataDir.mkdirs();
                markerFile.createNewFile();
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Failed to create a temporary dimension marker file '{}'", (Object)markerFile.getAbsolutePath(), (Object)e);
            }
        }
    }

    public static File getWorldJEDDataDirectory(File worldDir) {
        return new File(new File(worldDir, "data"), "justenoughdimensions");
    }

    public static File getTemporaryDimensionMarkerFile(File jedDataDir) {
        return new File(jedDataDir, "jed_temporary_dimension.txt");
    }

    private static boolean isNewWorld(File worldDir) {
        File regionDir = new File(worldDir, "region");
        return !regionDir.exists();
    }

    public static NBTTagCompound loadWorldInfoFromFile(World world, @Nullable File worldDir) {
        if (worldDir == null) {
            JustEnoughDimensions.logInfo("WorldFileUtils.loadWorldInfoFromFile(): null worldDir", new Object[0]);
            return null;
        }
        File levelFile = new File(worldDir, JED_LEVEL_FILENAME);
        if (levelFile.exists()) {
            try {
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(levelFile));
                nbt = world.func_73046_m().getDataFixer().func_188257_a((IFixType)FixTypes.LEVEL, nbt.func_74775_l("Data"));
                JustEnoughDimensions.logInfo("WorldFileUtils.loadWorldInfoFromFile(): Read world info from file '{}'", levelFile.getPath());
                return nbt;
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.warn("Exception reading " + levelFile.getPath(), (Throwable)e);
                return null;
            }
        }
        JustEnoughDimensions.logInfo("WorldFileUtils.loadWorldInfoFromFile(): '{}' didn't exist for dimension {}", JED_LEVEL_FILENAME, world.field_73011_w.getDimension());
        return null;
    }

    private static void saveWorldInfoToFile(World world, @Nullable File worldDir) {
        if (worldDir == null) {
            JustEnoughDimensions.logger.warn("WorldFileUtils.saveWorldInfoToFile(): No worldDir found");
            return;
        }
        WorldInfo info = world.func_72912_H();
        info.func_176145_a(world.func_175723_af().func_177741_h());
        info.func_176124_d(world.func_175723_af().func_177731_f());
        info.func_176141_c(world.func_175723_af().func_177721_g());
        info.func_176129_e(world.func_175723_af().func_177742_m());
        info.func_176125_f(world.func_175723_af().func_177727_n());
        info.func_176122_j(world.func_175723_af().func_177748_q());
        info.func_176136_k(world.func_175723_af().func_177740_p());
        info.func_176118_b(world.func_175723_af().func_177751_j());
        info.func_176135_e(world.func_175723_af().func_177732_i());
        NBTTagCompound rootTag = new NBTTagCompound();
        NBTTagCompound playerNBT = world.func_73046_m().func_184103_al().func_72378_q();
        rootTag.func_74782_a("Data", (NBTBase)info.func_76082_a(playerNBT));
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            try {
                File fileNew = new File(worldDir, "jed_level.dat_new");
                File fileOld = new File(worldDir, "jed_level.dat_old");
                File fileCurrent = new File(worldDir, JED_LEVEL_FILENAME);
                CompressedStreamTools.func_74799_a((NBTTagCompound)rootTag, (OutputStream)new FileOutputStream(fileNew));
                if (fileOld.exists()) {
                    fileOld.delete();
                }
                fileCurrent.renameTo(fileOld);
                if (fileCurrent.exists()) {
                    JustEnoughDimensions.logger.error("Failed to rename file '{}' to '{}'", (Object)fileCurrent.getAbsolutePath(), (Object)fileOld.getAbsolutePath());
                    return false;
                }
                fileNew.renameTo(fileCurrent);
                if (fileNew.exists()) {
                    JustEnoughDimensions.logger.error("Failed to rename file '{}' to '{}'", (Object)fileNew.getAbsolutePath(), (Object)fileCurrent.getAbsolutePath());
                    return false;
                }
            }
            catch (Exception e) {
                JustEnoughDimensions.logger.error("WorldFileUtils.saveWorldInfoToFile(): Failed to save world info to file for dimension {}", (Object)world.field_73011_w.getDimension(), (Object)e);
            }
            return false;
        });
    }

    public static void saveCustomWorldInfoToFile(World world) {
        if (Configs.enableSeparateWorldInfo && !world.field_72995_K) {
            WorldFileUtils.saveWorldInfoToFile(world, WorldFileUtils.getWorldDirectory(world));
        }
    }
}

