/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.recipe.Materialization;
import com.shinoow.abyssalcraft.api.recipe.MaterializerRecipes;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.Materializer")
public class Materializer {
    @ZenMethod
    public static void addMaterialization(IItemStack output, IItemStack[] input) {
        ItemStack stack = ACMT.toStack(output);
        ItemStack[] stacks = new ItemStack[input.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = ACMT.toStack(input[i]);
        }
        ACMTMisc.TASKS.add(new Add(stack, stacks));
    }

    @ZenMethod
    public static void removeMaterialization(IItemStack output) {
        ACMTMisc.TASKS.add(new Remove(ACMT.toStack(output)));
    }

    @ZenMethod
    public static void addCrystal(IItemStack stack) {
        ACMTMisc.TASKS.add(new AddCrystal(ACMT.toStack(stack)));
    }

    private static class AddCrystal
    implements IAction {
        private ItemStack stack;

        public AddCrystal(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            AbyssalCraftAPI.addCrystal((ItemStack)this.stack);
        }

        public String describe() {
            return String.format("Added %s to the Crystal List", this.stack);
        }
    }

    private static class Remove
    implements IAction {
        private ItemStack output;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            ArrayList temp = Lists.newArrayList();
            for (Materialization mat : MaterializerRecipes.instance().getMaterializationList()) {
                if (!APIUtils.areStacksEqual((ItemStack)this.output, (ItemStack)mat.output)) continue;
                temp.add(mat);
            }
            for (Materialization mat : temp) {
                MaterializerRecipes.instance().getMaterializationList().remove(mat);
            }
        }

        public String describe() {
            return String.format("Removing Materialization recipes for %s", this.output);
        }
    }

    private static class Add
    implements IAction {
        private ItemStack output;
        private ItemStack[] input;

        public Add(ItemStack output, ItemStack[] input) {
            this.output = output;
            this.input = input;
        }

        public void apply() {
            AbyssalCraftAPI.addMaterialization((ItemStack)this.output, (ItemStack[])this.input);
        }

        public String describe() {
            return String.format("Adding Materialization recipe for %s (input: %s)", this.output, this.getArrayContent(this.input));
        }

        private String getArrayContent(ItemStack[] array) {
            String stuff = "[";
            for (ItemStack stack : array) {
                stuff = stuff + stack + ", ";
            }
            stuff = stuff.substring(0, stuff.length() - 2);
            stuff = stuff + "]";
            return stuff;
        }
    }
}

