/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.portality.network;

import com.buuz135.portality.tile.TileController;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PortalRenameMessage
implements IMessage {
    private long tileLocation;
    private String name;

    public PortalRenameMessage() {
    }

    public PortalRenameMessage(String name, BlockPos tile) {
        this.name = name;
        this.tileLocation = tile.func_177986_g();
    }

    public void fromBytes(ByteBuf buf) {
        this.tileLocation = buf.readLong();
        int length = buf.readInt();
        this.name = String.valueOf(buf.readCharSequence(length, Charset.defaultCharset()));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.tileLocation);
        buf.writeInt(this.name.length());
        buf.writeBytes(this.name.getBytes());
    }

    public static class PortalRenameHandler
    implements IMessageHandler<PortalRenameMessage, IMessage> {
        public IMessage onMessage(PortalRenameMessage message, MessageContext ctx) {
            EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
            serverPlayer.func_71121_q().func_152344_a(() -> {
                TileController controller;
                World world = serverPlayer.field_70170_p;
                BlockPos pos = BlockPos.func_177969_a((long)message.tileLocation);
                if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileController && (controller = (TileController)world.func_175625_s(pos)).getOwner().equals(serverPlayer.func_110124_au())) {
                    controller.setName(message.name);
                }
            });
            return null;
        }
    }
}

