/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.function.IPredicate;
import org.magicwerk.brownies.collections.primitive.LongObjBigList;
import org.magicwerk.brownies.collections.primitive.LongObjGapList;

public abstract class ILongList
implements Cloneable,
Serializable {
    private static final int TRANSFER_COPY = 0;
    private static final int TRANSFER_MOVE = 1;
    private static final int TRANSFER_REMOVE = 2;

    static long[] toArray(Collection<Long> coll) {
        Object[] values2 = coll.toArray();
        long[] v = new long[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            v[i] = (Long)values2[i];
        }
        return v;
    }

    public ILongList copy() {
        return (ILongList)this.clone();
    }

    public abstract ILongList unmodifiableList();

    public Object clone() {
        try {
            ILongList list2 = (ILongList)super.clone();
            list2.doClone(this);
            return list2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(ILongList var1);

    public void clear() {
        this.doClear();
    }

    protected void doClear() {
        this.doRemoveAll(0, this.size());
    }

    public void resize(int len2, long elem) {
        this.checkLength(len2);
        int size2 = this.size();
        if (len2 < size2) {
            this.remove(len2, size2 - len2);
        } else {
            for (int i = size2; i < len2; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len2);
    }

    public abstract int size();

    public abstract int capacity();

    public long get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract long doGet(int var1);

    protected abstract long doSet(int var1, long var2);

    public long set(int index, long elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    public long put(int index, long elem) {
        this.checkIndexAdd(index);
        if (index < this.size()) {
            return this.doSet(index, elem);
        }
        this.doAdd(-1, elem);
        return 0L;
    }

    protected abstract long doReSet(int var1, long var2);

    protected abstract long getDefaultElem();

    protected void doModify() {
    }

    public boolean add(long elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, long elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, long var2);

    public long remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract long doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof LongObjGapList) {
            obj = ((LongObjGapList)obj).list;
        } else if (obj instanceof LongObjBigList) {
            obj = ((LongObjBigList)obj).list;
        }
        if (!(obj instanceof ILongList)) {
            return false;
        }
        ILongList list2 = (ILongList)obj;
        int size2 = this.size();
        if (size2 != list2.size()) {
            return false;
        }
        for (int i = 0; i < size2; ++i) {
            if (ILongList.equalsElem(this.doGet(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            long elem = this.doGet(i);
            hashCode = 31 * hashCode + ILongList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(long elem1, long elem2) {
        return elem1 == elem2;
    }

    static int hashCodeElem(long elem) {
        return (int)elem;
    }

    public int getCount(long elem) {
        int count = 0;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!ILongList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public ILongList getAll(long elem) {
        ILongList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            long e = this.doGet(i);
            if (!ILongList.equalsElem(e, elem)) continue;
            list2.add(e);
        }
        return list2;
    }

    public ILongList getWhere(IPredicate predicate) {
        ILongList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            long e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
        }
        return list2;
    }

    public void removeWhere(IPredicate predicate) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            long e = this.doGet(i);
            if (!predicate.test(e)) continue;
            this.doRemove(i);
            --size2;
            --i;
        }
    }

    public void retainWhere(IPredicate predicate) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            long e = this.doGet(i);
            if (predicate.test(e)) continue;
            this.doRemove(i);
            --size2;
            --i;
        }
    }

    public ILongList extractWhere(IPredicate predicate) {
        ILongList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            long e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
            this.doRemove(i);
            --size2;
            --i;
        }
        return list2;
    }

    public Set getDistinct() {
        HashSet<Long> set = new HashSet<Long>();
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(IFunction<Long, R> mapper) {
        int size2 = this.size();
        GapList<R> mappedList = new GapList<R>(size2);
        for (int i = 0; i < size2; ++i) {
            long e = this.doGet(i);
            ((IList)mappedList).add(mapper.apply(e));
        }
        return mappedList;
    }

    public void filter(IPredicate<Long> predicate) {
        ILongList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            long e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
        }
        this.doAssign(list2);
    }

    public int indexOf(long elem) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!ILongList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!ILongList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(long elem, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size2 = this.size();
        for (int i = fromIndex; i < size2; ++i) {
            if (!ILongList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long elem, int fromIndex) {
        int size2 = this.size();
        if (fromIndex >= size2) {
            fromIndex = size2 - 1;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!ILongList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(long elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(long elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean addIfAbsent(long elem) {
        if (this.contains(elem)) {
            return false;
        }
        return this.add(elem);
    }

    public boolean containsAny(Collection<Long> coll) {
        for (long elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Long> coll) {
        for (long elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public ILongList removeAll(long elem) {
        ILongList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            long e = this.doGet(i);
            if (!ILongList.equalsElem(elem, e)) continue;
            list2.add(e);
            this.doRemove(i);
            --size2;
            --i;
        }
        return list2;
    }

    public boolean removeAll(Collection<Long> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(ILongList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Long> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(ILongList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public long[] toArray() {
        int size2 = this.size();
        long[] array = new long[size2];
        this.doGetAll(array, 0, size2);
        return array;
    }

    public long[] toArray(int index, int len2) {
        long[] array = new long[len2];
        this.doGetAll(array, index, len2);
        return array;
    }

    public long[] toArray(long[] array) {
        int size2 = this.size();
        if (array.length < size2) {
            array = (long[])Array.newInstance(array.getClass().getComponentType(), size2);
        }
        this.doGetAll(array, 0, size2);
        if (array.length > size2) {
            array[size2] = 0L;
        }
        return array;
    }

    protected void doGetAll(long[] array, int index, int len2) {
        for (int i = 0; i < len2; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    protected boolean doAddAll(int index, ILongList list2) {
        int listSize = list2.size();
        this.doEnsureCapacity(this.size() + listSize);
        if (listSize == 0) {
            return false;
        }
        boolean changed = false;
        int prevSize = this.size();
        for (int i = 0; i < listSize; ++i) {
            long elem = list2.get(i);
            if (!this.doAdd(index, elem)) continue;
            changed = true;
            if (index == -1 || prevSize == this.size()) continue;
            prevSize = this.size();
            ++index;
        }
        return changed;
    }

    public long peek() {
        if (this.size() == 0) {
            return 0L;
        }
        return this.getFirst();
    }

    public long element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public long poll() {
        if (this.size() == 0) {
            return 0L;
        }
        return this.doRemove(0);
    }

    public long remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(long elem) {
        return this.doAdd(-1, elem);
    }

    public long getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public long getLast() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size2 - 1);
    }

    public void addFirst(long elem) {
        this.doAdd(0, elem);
    }

    public void addLast(long elem) {
        this.doAdd(-1, elem);
    }

    public long removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public long removeLast() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size2 - 1);
    }

    public boolean offerFirst(long elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(long elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public long peekFirst() {
        if (this.size() == 0) {
            return 0L;
        }
        return this.doGet(0);
    }

    public long peekLast() {
        int size2 = this.size();
        if (size2 == 0) {
            return 0L;
        }
        return this.doGet(size2 - 1);
    }

    public long pollFirst() {
        if (this.size() == 0) {
            return 0L;
        }
        return this.doRemove(0);
    }

    public long pollLast() {
        int size2 = this.size();
        if (size2 == 0) {
            return 0L;
        }
        return this.doRemove(size2 - 1);
    }

    public long pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(long elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(long elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(long elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void transferCopy(ILongList src, int srcIndex, int srcLen, ILongList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.copy(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(0, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferMove(ILongList src, int srcIndex, int srcLen, ILongList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.move(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(1, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferRemove(ILongList src, int srcIndex, int srcLen, ILongList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.drag(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(2, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    void doTransfer(int transferMode, int srcIndex, int srcLen, ILongList dst, int dstIndex, int dstLen) {
        if (srcLen == -1) {
            srcLen = this.size() - srcIndex;
        }
        this.checkRange(srcIndex, srcLen);
        if (dstIndex == -1) {
            dstIndex = dst.size();
        } else {
            dst.checkIndexAdd(dstIndex);
        }
        if (dstLen == -1) {
            dstLen = dst.size() - dstIndex;
        } else {
            dst.checkLength(dstLen);
        }
        long defaultElem = this.getDefaultElem();
        if (dstLen > srcLen) {
            dst.remove(dstIndex, dstLen - srcLen);
        } else if (srcLen > dstLen) {
            dst.addMult(dstIndex, srcLen - dstLen, defaultElem);
        }
        if (transferMode == 1) {
            for (int i = 0; i < srcLen; ++i) {
                long elem = this.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        } else {
            for (int i = 0; i < srcLen; ++i) {
                long elem = this.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
            if (transferMode == 2) {
                this.remove(srcIndex, srcLen);
            }
        }
    }

    public static void transferSwap(ILongList src, int srcIndex, ILongList dst, int dstIndex, int len2) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len2);
        } else {
            src.doTransferSwap(srcIndex, dst, dstIndex, len2);
        }
    }

    void doTransferSwap(int srcIndex, ILongList dst, int dstIndex, int len2) {
        this.checkRange(srcIndex, len2);
        dst.checkRange(dstIndex, len2);
        for (int i = 0; i < len2; ++i) {
            long swap = this.doGet(srcIndex + i);
            swap = dst.doSet(dstIndex + i, swap);
            this.doSet(srcIndex + i, swap);
        }
    }

    protected abstract ILongList doCreate(int var1);

    protected abstract void doAssign(ILongList var1);

    public ILongList getAll(int index, int len2) {
        this.checkRange(index, len2);
        ILongList list2 = this.doCreate(len2);
        for (int i = 0; i < len2; ++i) {
            list2.add(this.doGet(index + i));
        }
        return list2;
    }

    public ILongList extract(int index, int len2) {
        this.checkRange(index, len2);
        ILongList list2 = this.doCreate(len2);
        for (int i = 0; i < len2; ++i) {
            list2.add(this.doGet(index + i));
        }
        this.remove(index, len2);
        return list2;
    }

    public long[] getArray(int index, int len2) {
        this.checkRange(index, len2);
        long[] array = new long[len2];
        for (int i = 0; i < len2; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void remove(int index, int len2) {
        this.checkRange(index, len2);
        this.doRemoveAll(index, len2);
    }

    protected void doRemoveAll(int index, int len2) {
        for (int i = index + len2 - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public boolean addAll(ILongList list2) {
        return this.doAddAll(-1, list2);
    }

    public boolean addAll(int index, ILongList list2) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list2);
    }

    public boolean addAll(Collection<Long> coll) {
        if (coll instanceof List) {
            return this.doAddAll(-1, new IReadOnlyLongListFromList((List)coll));
        }
        return this.doAddAll(-1, new IReadOnlyLongListFromCollection(coll));
    }

    public boolean addAll(int index, Collection<Long> coll) {
        this.checkIndexAdd(index);
        if (coll instanceof List) {
            return this.doAddAll(index, new IReadOnlyLongListFromList((List)coll));
        }
        return this.doAddAll(index, new IReadOnlyLongListFromCollection(coll));
    }

    public boolean addArray(long ... elems) {
        return this.doAddAll(-1, new IReadOnlyLongListFromArray(elems));
    }

    public boolean addArray(int index, long ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyLongListFromArray(elems));
    }

    public boolean addMult(int len2, long elem) {
        return this.doAddAll(-1, new IReadOnlyLongListFromMult(len2, elem));
    }

    public boolean addMult(int index, int len2, long elem) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyLongListFromMult(len2, elem));
    }

    public void setAll(int index, ILongList list2) {
        int listSize = list2.size();
        this.checkRange(index, listSize);
        this.doReplaceAll(index, listSize, list2);
    }

    public void setAll(int index, Collection<Long> coll) {
        int collSize = coll.size();
        this.checkRange(index, collSize);
        if (coll instanceof List) {
            this.doReplaceAll(index, collSize, new IReadOnlyLongListFromList((List)coll));
        } else {
            this.doReplaceAll(index, collSize, new IReadOnlyLongListFromCollection(coll));
        }
    }

    public void setArray(int index, long ... elems) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyLongListFromArray(elems));
    }

    public void setMult(int index, int len2, long elem) {
        this.checkRange(index, len2);
        this.doReplaceAll(index, len2, new IReadOnlyLongListFromMult(len2, elem));
    }

    public void putAll(int index, ILongList list2) {
        this.checkIndexAdd(index);
        this.checkNonNull(list2);
        int len2 = this.size() - index;
        if (list2 != null && list2.size() < len2) {
            len2 = list2.size();
        }
        this.doReplaceAll(index, len2, list2);
    }

    public void putAll(int index, Collection<Long> coll) {
        if (coll instanceof ILongList) {
            this.putAll(index, (ILongList)((Object)coll));
        } else if (coll instanceof List) {
            this.putAll(index, new IReadOnlyLongListFromList((List)coll));
        } else {
            this.putAll(index, new IReadOnlyLongListFromCollection(coll));
        }
    }

    public void putArray(int index, long ... elems) {
        this.putAll(index, new IReadOnlyLongListFromArray(elems));
    }

    public void putMult(int index, int len2, long elem) {
        this.putAll(index, new IReadOnlyLongListFromMult(len2, elem));
    }

    public void initAll(ILongList list2) {
        this.checkNonNull(list2);
        this.doReplaceAll(0, this.size(), list2);
    }

    public void initAll(Collection<Long> coll) {
        if (coll instanceof ILongList) {
            this.initAll((ILongList)((Object)coll));
        } else if (coll instanceof List) {
            this.initAll(new IReadOnlyLongListFromList((List)coll));
        } else {
            this.initAll(new IReadOnlyLongListFromCollection(coll));
        }
    }

    public void initArray(long ... elems) {
        this.initAll(new IReadOnlyLongListFromArray(elems));
    }

    public void initMult(int len2, long elem) {
        this.checkLength(len2);
        this.initAll(new IReadOnlyLongListFromMult(len2, elem));
    }

    public void replaceAll(int index, int len2, Collection<Long> coll) {
        if (coll instanceof ILongList) {
            this.replaceAll(index, len2, (ILongList)((Object)coll));
        } else if (coll instanceof List) {
            this.replaceAll(index, len2, new IReadOnlyLongListFromList((List)coll));
        } else {
            this.replaceAll(index, len2, new IReadOnlyLongListFromCollection(coll));
        }
    }

    public void replaceArray(int index, int len2, long ... elems) {
        this.replaceAll(index, len2, new IReadOnlyLongListFromArray(elems));
    }

    public void replaceMult(int index, int len2, int numElems, long elem) {
        this.replaceAll(index, len2, new IReadOnlyLongListFromMult(numElems, elem));
    }

    public void replaceAll(int index, int len2, ILongList list2) {
        if (index == -1) {
            index = this.size();
        } else {
            this.checkIndexAdd(index);
        }
        if (len2 == -1) {
            len2 = this.size() - index;
            if (list2 != null && list2.size() < len2) {
                len2 = list2.size();
            }
        } else {
            this.checkRange(index, len2);
        }
        this.doReplaceAll(index, len2, list2);
    }

    protected boolean doReplaceAll(int index, int len2, ILongList list2) {
        assert (index >= 0 && index <= this.size());
        assert (len2 >= 0 && index + len2 <= this.size());
        int srcLen = 0;
        if (list2 != null) {
            srcLen = list2.size();
        }
        this.doEnsureCapacity(this.size() - len2 + srcLen);
        this.doRemoveAll(index, len2);
        for (int i = 0; i < srcLen; ++i) {
            if (this.doAdd(index + i, list2.doGet(i))) continue;
            --index;
        }
        return len2 > 0 || srcLen > 0;
    }

    public void fill(long elem) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            this.doSet(i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len2) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len2);
                this.checkRange(dstIndex, len2);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len2 - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len2; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len2) {
        int fill;
        int i;
        this.checkRange(srcIndex, len2);
        this.checkRange(dstIndex, len2);
        if (srcIndex < dstIndex) {
            for (i = len2 - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len2; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len2, dstIndex - srcIndex);
            this.setMult(srcIndex, fill, 0L);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len2, srcIndex - dstIndex);
            this.setMult(srcIndex + len2 - fill, fill, 0L);
        }
    }

    public void drag(int srcIndex, int dstIndex, int len2) {
        this.checkRange(srcIndex, len2);
        this.checkRange(dstIndex, len2);
        if (srcIndex < dstIndex) {
            this.doRotate(srcIndex, len2 + (dstIndex - srcIndex), dstIndex - srcIndex);
        } else if (srcIndex > dstIndex) {
            this.doRotate(dstIndex, len2 + (srcIndex - dstIndex), dstIndex - srcIndex);
        }
    }

    public void swap(int index1, int index2, int len2) {
        this.checkRange(index1, len2);
        this.checkRange(index2, len2);
        if (index1 < index2 && index1 + len2 > index2 || index1 > index2 && index2 + len2 > index1) {
            throw new IndexOutOfBoundsException("Swap ranges overlap");
        }
        for (int i = 0; i < len2; ++i) {
            long swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len2) {
        this.checkRange(index, len2);
        int pos1 = index;
        int pos2 = index + len2 - 1;
        int mid = len2 / 2;
        for (int i = 0; i < mid; ++i) {
            long swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len2, int distance) {
        this.checkRange(index, len2);
        this.doRotate(index, len2, distance);
    }

    protected void doRotate(int index, int len2, int distance) {
        if ((distance %= len2) < 0) {
            distance += len2;
        }
        if (distance == 0) {
            return;
        }
        assert (distance >= 0 && distance < len2);
        int num = 0;
        int start = 0;
        while (num != len2) {
            long elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len2) {
                    i -= len2;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(long key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, long var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len2) {
        if (index < 0 || len2 < 0 || index + len2 > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len2 + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int len2) {
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkLengths(int len1, int len2) {
        if (len1 != len2) {
            throw new IndexOutOfBoundsException("Invalid lengths: " + len1 + ", " + len2);
        }
        if (len1 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len1);
        }
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument may not be 0");
        }
    }

    protected static class IReadOnlyLongListFromList
    extends IReadOnlyLongList {
        List<Long> list2;

        IReadOnlyLongListFromList(List<Long> list2) {
            this.list2 = list2;
        }

        @Override
        public int size() {
            return this.list2.size();
        }

        @Override
        protected long doGet(int index) {
            return this.list2.get(index);
        }
    }

    protected static class IReadOnlyLongListFromCollection
    extends IReadOnlyLongList {
        long[] array;

        IReadOnlyLongListFromCollection(Collection<Long> coll) {
            this.array = IReadOnlyLongListFromCollection.toArray(coll);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected long doGet(int index) {
            return this.array[index];
        }
    }

    protected static class IReadOnlyLongListFromMult
    extends IReadOnlyLongList {
        int len;
        long elem;

        IReadOnlyLongListFromMult(int len2, long elem) {
            this.checkLength(len2);
            this.len = len2;
            this.elem = elem;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        protected long doGet(int index) {
            return this.elem;
        }
    }

    protected static class IReadOnlyLongListFromArray
    extends IReadOnlyLongList {
        long[] array;

        IReadOnlyLongListFromArray(long[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected long doGet(int index) {
            return this.array[index];
        }
    }

    protected static abstract class IReadOnlyLongList
    extends ILongList {
        protected IReadOnlyLongList() {
        }

        @Override
        public ILongList unmodifiableList() {
            this.error();
            return null;
        }

        @Override
        protected void doClone(ILongList that) {
            this.error();
        }

        @Override
        public int capacity() {
            this.error();
            return 0;
        }

        @Override
        protected long doSet(int index, long elem) {
            this.error();
            return 0L;
        }

        @Override
        protected long doReSet(int index, long elem) {
            this.error();
            return 0L;
        }

        @Override
        protected long getDefaultElem() {
            this.error();
            return 0L;
        }

        @Override
        protected boolean doAdd(int index, long elem) {
            this.error();
            return false;
        }

        @Override
        protected long doRemove(int index) {
            this.error();
            return 0L;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected ILongList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(ILongList that) {
            this.error();
        }

        @Override
        public void sort(int index, int len2) {
            this.error();
        }

        @Override
        public int binarySearch(int index, int len2, long key) {
            this.error();
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is read-only");
        }
    }
}

