/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.function.IPredicate;
import org.magicwerk.brownies.collections.primitive.DoubleObjBigList;
import org.magicwerk.brownies.collections.primitive.DoubleObjGapList;

public abstract class IDoubleList
implements Cloneable,
Serializable {
    private static final int TRANSFER_COPY = 0;
    private static final int TRANSFER_MOVE = 1;
    private static final int TRANSFER_REMOVE = 2;

    static double[] toArray(Collection<Double> coll) {
        Object[] values2 = coll.toArray();
        double[] v = new double[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            v[i] = (Double)values2[i];
        }
        return v;
    }

    public IDoubleList copy() {
        return (IDoubleList)this.clone();
    }

    public abstract IDoubleList unmodifiableList();

    public Object clone() {
        try {
            IDoubleList list2 = (IDoubleList)super.clone();
            list2.doClone(this);
            return list2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IDoubleList var1);

    public void clear() {
        this.doClear();
    }

    protected void doClear() {
        this.doRemoveAll(0, this.size());
    }

    public void resize(int len2, double elem) {
        this.checkLength(len2);
        int size2 = this.size();
        if (len2 < size2) {
            this.remove(len2, size2 - len2);
        } else {
            for (int i = size2; i < len2; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len2);
    }

    public abstract int size();

    public abstract int capacity();

    public double get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract double doGet(int var1);

    protected abstract double doSet(int var1, double var2);

    public double set(int index, double elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    public double put(int index, double elem) {
        this.checkIndexAdd(index);
        if (index < this.size()) {
            return this.doSet(index, elem);
        }
        this.doAdd(-1, elem);
        return 0.0;
    }

    protected abstract double doReSet(int var1, double var2);

    protected abstract double getDefaultElem();

    protected void doModify() {
    }

    public boolean add(double elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, double elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, double var2);

    public double remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract double doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DoubleObjGapList) {
            obj = ((DoubleObjGapList)obj).list;
        } else if (obj instanceof DoubleObjBigList) {
            obj = ((DoubleObjBigList)obj).list;
        }
        if (!(obj instanceof IDoubleList)) {
            return false;
        }
        IDoubleList list2 = (IDoubleList)obj;
        int size2 = this.size();
        if (size2 != list2.size()) {
            return false;
        }
        for (int i = 0; i < size2; ++i) {
            if (IDoubleList.equalsElem(this.doGet(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            double elem = this.doGet(i);
            hashCode = 31 * hashCode + IDoubleList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(double elem1, double elem2) {
        return Double.doubleToLongBits(elem1) == Double.doubleToLongBits(elem2);
    }

    static int hashCodeElem(double elem) {
        return (int)elem;
    }

    public int getCount(double elem) {
        int count = 0;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public IDoubleList getAll(double elem) {
        IDoubleList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            double e = this.doGet(i);
            if (!IDoubleList.equalsElem(e, elem)) continue;
            list2.add(e);
        }
        return list2;
    }

    public IDoubleList getWhere(IPredicate predicate) {
        IDoubleList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            double e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
        }
        return list2;
    }

    public void removeWhere(IPredicate predicate) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            double e = this.doGet(i);
            if (!predicate.test(e)) continue;
            this.doRemove(i);
            --size2;
            --i;
        }
    }

    public void retainWhere(IPredicate predicate) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            double e = this.doGet(i);
            if (predicate.test(e)) continue;
            this.doRemove(i);
            --size2;
            --i;
        }
    }

    public IDoubleList extractWhere(IPredicate predicate) {
        IDoubleList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            double e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
            this.doRemove(i);
            --size2;
            --i;
        }
        return list2;
    }

    public Set getDistinct() {
        HashSet<Double> set = new HashSet<Double>();
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(IFunction<Double, R> mapper) {
        int size2 = this.size();
        GapList<R> mappedList = new GapList<R>(size2);
        for (int i = 0; i < size2; ++i) {
            double e = this.doGet(i);
            ((IList)mappedList).add(mapper.apply(e));
        }
        return mappedList;
    }

    public void filter(IPredicate<Double> predicate) {
        IDoubleList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            double e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
        }
        this.doAssign(list2);
    }

    public int indexOf(double elem) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(double elem, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size2 = this.size();
        for (int i = fromIndex; i < size2; ++i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double elem, int fromIndex) {
        int size2 = this.size();
        if (fromIndex >= size2) {
            fromIndex = size2 - 1;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!IDoubleList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(double elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(double elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean addIfAbsent(double elem) {
        if (this.contains(elem)) {
            return false;
        }
        return this.add(elem);
    }

    public boolean containsAny(Collection<Double> coll) {
        for (double elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Double> coll) {
        for (double elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public IDoubleList removeAll(double elem) {
        IDoubleList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            double e = this.doGet(i);
            if (!IDoubleList.equalsElem(elem, e)) continue;
            list2.add(e);
            this.doRemove(i);
            --size2;
            --i;
        }
        return list2;
    }

    public boolean removeAll(Collection<Double> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(IDoubleList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Double> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(IDoubleList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public double[] toArray() {
        int size2 = this.size();
        double[] array = new double[size2];
        this.doGetAll(array, 0, size2);
        return array;
    }

    public double[] toArray(int index, int len2) {
        double[] array = new double[len2];
        this.doGetAll(array, index, len2);
        return array;
    }

    public double[] toArray(double[] array) {
        int size2 = this.size();
        if (array.length < size2) {
            array = (double[])Array.newInstance(array.getClass().getComponentType(), size2);
        }
        this.doGetAll(array, 0, size2);
        if (array.length > size2) {
            array[size2] = 0.0;
        }
        return array;
    }

    protected void doGetAll(double[] array, int index, int len2) {
        for (int i = 0; i < len2; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    protected boolean doAddAll(int index, IDoubleList list2) {
        int listSize = list2.size();
        this.doEnsureCapacity(this.size() + listSize);
        if (listSize == 0) {
            return false;
        }
        boolean changed = false;
        int prevSize = this.size();
        for (int i = 0; i < listSize; ++i) {
            double elem = list2.get(i);
            if (!this.doAdd(index, elem)) continue;
            changed = true;
            if (index == -1 || prevSize == this.size()) continue;
            prevSize = this.size();
            ++index;
        }
        return changed;
    }

    public double peek() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.getFirst();
    }

    public double element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public double poll() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doRemove(0);
    }

    public double remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(double elem) {
        return this.doAdd(-1, elem);
    }

    public double getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public double getLast() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size2 - 1);
    }

    public void addFirst(double elem) {
        this.doAdd(0, elem);
    }

    public void addLast(double elem) {
        this.doAdd(-1, elem);
    }

    public double removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public double removeLast() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size2 - 1);
    }

    public boolean offerFirst(double elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(double elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public double peekFirst() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doGet(0);
    }

    public double peekLast() {
        int size2 = this.size();
        if (size2 == 0) {
            return 0.0;
        }
        return this.doGet(size2 - 1);
    }

    public double pollFirst() {
        if (this.size() == 0) {
            return 0.0;
        }
        return this.doRemove(0);
    }

    public double pollLast() {
        int size2 = this.size();
        if (size2 == 0) {
            return 0.0;
        }
        return this.doRemove(size2 - 1);
    }

    public double pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(double elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(double elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(double elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void transferCopy(IDoubleList src, int srcIndex, int srcLen, IDoubleList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.copy(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(0, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferMove(IDoubleList src, int srcIndex, int srcLen, IDoubleList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.move(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(1, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferRemove(IDoubleList src, int srcIndex, int srcLen, IDoubleList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.drag(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(2, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    void doTransfer(int transferMode, int srcIndex, int srcLen, IDoubleList dst, int dstIndex, int dstLen) {
        if (srcLen == -1) {
            srcLen = this.size() - srcIndex;
        }
        this.checkRange(srcIndex, srcLen);
        if (dstIndex == -1) {
            dstIndex = dst.size();
        } else {
            dst.checkIndexAdd(dstIndex);
        }
        if (dstLen == -1) {
            dstLen = dst.size() - dstIndex;
        } else {
            dst.checkLength(dstLen);
        }
        double defaultElem = this.getDefaultElem();
        if (dstLen > srcLen) {
            dst.remove(dstIndex, dstLen - srcLen);
        } else if (srcLen > dstLen) {
            dst.addMult(dstIndex, srcLen - dstLen, defaultElem);
        }
        if (transferMode == 1) {
            for (int i = 0; i < srcLen; ++i) {
                double elem = this.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        } else {
            for (int i = 0; i < srcLen; ++i) {
                double elem = this.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
            if (transferMode == 2) {
                this.remove(srcIndex, srcLen);
            }
        }
    }

    public static void transferSwap(IDoubleList src, int srcIndex, IDoubleList dst, int dstIndex, int len2) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len2);
        } else {
            src.doTransferSwap(srcIndex, dst, dstIndex, len2);
        }
    }

    void doTransferSwap(int srcIndex, IDoubleList dst, int dstIndex, int len2) {
        this.checkRange(srcIndex, len2);
        dst.checkRange(dstIndex, len2);
        for (int i = 0; i < len2; ++i) {
            double swap = this.doGet(srcIndex + i);
            swap = dst.doSet(dstIndex + i, swap);
            this.doSet(srcIndex + i, swap);
        }
    }

    protected abstract IDoubleList doCreate(int var1);

    protected abstract void doAssign(IDoubleList var1);

    public IDoubleList getAll(int index, int len2) {
        this.checkRange(index, len2);
        IDoubleList list2 = this.doCreate(len2);
        for (int i = 0; i < len2; ++i) {
            list2.add(this.doGet(index + i));
        }
        return list2;
    }

    public IDoubleList extract(int index, int len2) {
        this.checkRange(index, len2);
        IDoubleList list2 = this.doCreate(len2);
        for (int i = 0; i < len2; ++i) {
            list2.add(this.doGet(index + i));
        }
        this.remove(index, len2);
        return list2;
    }

    public double[] getArray(int index, int len2) {
        this.checkRange(index, len2);
        double[] array = new double[len2];
        for (int i = 0; i < len2; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void remove(int index, int len2) {
        this.checkRange(index, len2);
        this.doRemoveAll(index, len2);
    }

    protected void doRemoveAll(int index, int len2) {
        for (int i = index + len2 - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public boolean addAll(IDoubleList list2) {
        return this.doAddAll(-1, list2);
    }

    public boolean addAll(int index, IDoubleList list2) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list2);
    }

    public boolean addAll(Collection<Double> coll) {
        if (coll instanceof List) {
            return this.doAddAll(-1, new IReadOnlyDoubleListFromList((List)coll));
        }
        return this.doAddAll(-1, new IReadOnlyDoubleListFromCollection(coll));
    }

    public boolean addAll(int index, Collection<Double> coll) {
        this.checkIndexAdd(index);
        if (coll instanceof List) {
            return this.doAddAll(index, new IReadOnlyDoubleListFromList((List)coll));
        }
        return this.doAddAll(index, new IReadOnlyDoubleListFromCollection(coll));
    }

    public boolean addArray(double ... elems) {
        return this.doAddAll(-1, new IReadOnlyDoubleListFromArray(elems));
    }

    public boolean addArray(int index, double ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyDoubleListFromArray(elems));
    }

    public boolean addMult(int len2, double elem) {
        return this.doAddAll(-1, new IReadOnlyDoubleListFromMult(len2, elem));
    }

    public boolean addMult(int index, int len2, double elem) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyDoubleListFromMult(len2, elem));
    }

    public void setAll(int index, IDoubleList list2) {
        int listSize = list2.size();
        this.checkRange(index, listSize);
        this.doReplaceAll(index, listSize, list2);
    }

    public void setAll(int index, Collection<Double> coll) {
        int collSize = coll.size();
        this.checkRange(index, collSize);
        if (coll instanceof List) {
            this.doReplaceAll(index, collSize, new IReadOnlyDoubleListFromList((List)coll));
        } else {
            this.doReplaceAll(index, collSize, new IReadOnlyDoubleListFromCollection(coll));
        }
    }

    public void setArray(int index, double ... elems) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyDoubleListFromArray(elems));
    }

    public void setMult(int index, int len2, double elem) {
        this.checkRange(index, len2);
        this.doReplaceAll(index, len2, new IReadOnlyDoubleListFromMult(len2, elem));
    }

    public void putAll(int index, IDoubleList list2) {
        this.checkIndexAdd(index);
        this.checkNonNull(list2);
        int len2 = this.size() - index;
        if (list2 != null && list2.size() < len2) {
            len2 = list2.size();
        }
        this.doReplaceAll(index, len2, list2);
    }

    public void putAll(int index, Collection<Double> coll) {
        if (coll instanceof IDoubleList) {
            this.putAll(index, (IDoubleList)((Object)coll));
        } else if (coll instanceof List) {
            this.putAll(index, new IReadOnlyDoubleListFromList((List)coll));
        } else {
            this.putAll(index, new IReadOnlyDoubleListFromCollection(coll));
        }
    }

    public void putArray(int index, double ... elems) {
        this.putAll(index, new IReadOnlyDoubleListFromArray(elems));
    }

    public void putMult(int index, int len2, double elem) {
        this.putAll(index, new IReadOnlyDoubleListFromMult(len2, elem));
    }

    public void initAll(IDoubleList list2) {
        this.checkNonNull(list2);
        this.doReplaceAll(0, this.size(), list2);
    }

    public void initAll(Collection<Double> coll) {
        if (coll instanceof IDoubleList) {
            this.initAll((IDoubleList)((Object)coll));
        } else if (coll instanceof List) {
            this.initAll(new IReadOnlyDoubleListFromList((List)coll));
        } else {
            this.initAll(new IReadOnlyDoubleListFromCollection(coll));
        }
    }

    public void initArray(double ... elems) {
        this.initAll(new IReadOnlyDoubleListFromArray(elems));
    }

    public void initMult(int len2, double elem) {
        this.checkLength(len2);
        this.initAll(new IReadOnlyDoubleListFromMult(len2, elem));
    }

    public void replaceAll(int index, int len2, Collection<Double> coll) {
        if (coll instanceof IDoubleList) {
            this.replaceAll(index, len2, (IDoubleList)((Object)coll));
        } else if (coll instanceof List) {
            this.replaceAll(index, len2, new IReadOnlyDoubleListFromList((List)coll));
        } else {
            this.replaceAll(index, len2, new IReadOnlyDoubleListFromCollection(coll));
        }
    }

    public void replaceArray(int index, int len2, double ... elems) {
        this.replaceAll(index, len2, new IReadOnlyDoubleListFromArray(elems));
    }

    public void replaceMult(int index, int len2, int numElems, double elem) {
        this.replaceAll(index, len2, new IReadOnlyDoubleListFromMult(numElems, elem));
    }

    public void replaceAll(int index, int len2, IDoubleList list2) {
        if (index == -1) {
            index = this.size();
        } else {
            this.checkIndexAdd(index);
        }
        if (len2 == -1) {
            len2 = this.size() - index;
            if (list2 != null && list2.size() < len2) {
                len2 = list2.size();
            }
        } else {
            this.checkRange(index, len2);
        }
        this.doReplaceAll(index, len2, list2);
    }

    protected boolean doReplaceAll(int index, int len2, IDoubleList list2) {
        assert (index >= 0 && index <= this.size());
        assert (len2 >= 0 && index + len2 <= this.size());
        int srcLen = 0;
        if (list2 != null) {
            srcLen = list2.size();
        }
        this.doEnsureCapacity(this.size() - len2 + srcLen);
        this.doRemoveAll(index, len2);
        for (int i = 0; i < srcLen; ++i) {
            if (this.doAdd(index + i, list2.doGet(i))) continue;
            --index;
        }
        return len2 > 0 || srcLen > 0;
    }

    public void fill(double elem) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            this.doSet(i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len2) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len2);
                this.checkRange(dstIndex, len2);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len2 - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len2; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len2) {
        int fill;
        int i;
        this.checkRange(srcIndex, len2);
        this.checkRange(dstIndex, len2);
        if (srcIndex < dstIndex) {
            for (i = len2 - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len2; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len2, dstIndex - srcIndex);
            this.setMult(srcIndex, fill, 0.0);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len2, srcIndex - dstIndex);
            this.setMult(srcIndex + len2 - fill, fill, 0.0);
        }
    }

    public void drag(int srcIndex, int dstIndex, int len2) {
        this.checkRange(srcIndex, len2);
        this.checkRange(dstIndex, len2);
        if (srcIndex < dstIndex) {
            this.doRotate(srcIndex, len2 + (dstIndex - srcIndex), dstIndex - srcIndex);
        } else if (srcIndex > dstIndex) {
            this.doRotate(dstIndex, len2 + (srcIndex - dstIndex), dstIndex - srcIndex);
        }
    }

    public void swap(int index1, int index2, int len2) {
        this.checkRange(index1, len2);
        this.checkRange(index2, len2);
        if (index1 < index2 && index1 + len2 > index2 || index1 > index2 && index2 + len2 > index1) {
            throw new IndexOutOfBoundsException("Swap ranges overlap");
        }
        for (int i = 0; i < len2; ++i) {
            double swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len2) {
        this.checkRange(index, len2);
        int pos1 = index;
        int pos2 = index + len2 - 1;
        int mid = len2 / 2;
        for (int i = 0; i < mid; ++i) {
            double swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len2, int distance) {
        this.checkRange(index, len2);
        this.doRotate(index, len2, distance);
    }

    protected void doRotate(int index, int len2, int distance) {
        if ((distance %= len2) < 0) {
            distance += len2;
        }
        if (distance == 0) {
            return;
        }
        assert (distance >= 0 && distance < len2);
        int num = 0;
        int start = 0;
        while (num != len2) {
            double elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len2) {
                    i -= len2;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(double key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, double var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len2) {
        if (index < 0 || len2 < 0 || index + len2 > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len2 + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int len2) {
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkLengths(int len1, int len2) {
        if (len1 != len2) {
            throw new IndexOutOfBoundsException("Invalid lengths: " + len1 + ", " + len2);
        }
        if (len1 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len1);
        }
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument may not be 0");
        }
    }

    protected static class IReadOnlyDoubleListFromList
    extends IReadOnlyDoubleList {
        List<Double> list2;

        IReadOnlyDoubleListFromList(List<Double> list2) {
            this.list2 = list2;
        }

        @Override
        public int size() {
            return this.list2.size();
        }

        @Override
        protected double doGet(int index) {
            return this.list2.get(index);
        }
    }

    protected static class IReadOnlyDoubleListFromCollection
    extends IReadOnlyDoubleList {
        double[] array;

        IReadOnlyDoubleListFromCollection(Collection<Double> coll) {
            this.array = IReadOnlyDoubleListFromCollection.toArray(coll);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected double doGet(int index) {
            return this.array[index];
        }
    }

    protected static class IReadOnlyDoubleListFromMult
    extends IReadOnlyDoubleList {
        int len;
        double elem;

        IReadOnlyDoubleListFromMult(int len2, double elem) {
            this.checkLength(len2);
            this.len = len2;
            this.elem = elem;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        protected double doGet(int index) {
            return this.elem;
        }
    }

    protected static class IReadOnlyDoubleListFromArray
    extends IReadOnlyDoubleList {
        double[] array;

        IReadOnlyDoubleListFromArray(double[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected double doGet(int index) {
            return this.array[index];
        }
    }

    protected static abstract class IReadOnlyDoubleList
    extends IDoubleList {
        protected IReadOnlyDoubleList() {
        }

        @Override
        public IDoubleList unmodifiableList() {
            this.error();
            return null;
        }

        @Override
        protected void doClone(IDoubleList that) {
            this.error();
        }

        @Override
        public int capacity() {
            this.error();
            return 0;
        }

        @Override
        protected double doSet(int index, double elem) {
            this.error();
            return 0.0;
        }

        @Override
        protected double doReSet(int index, double elem) {
            this.error();
            return 0.0;
        }

        @Override
        protected double getDefaultElem() {
            this.error();
            return 0.0;
        }

        @Override
        protected boolean doAdd(int index, double elem) {
            this.error();
            return false;
        }

        @Override
        protected double doRemove(int index) {
            this.error();
            return 0.0;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IDoubleList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IDoubleList that) {
            this.error();
        }

        @Override
        public void sort(int index, int len2) {
            this.error();
        }

        @Override
        public int binarySearch(int index, int len2, double key) {
            this.error();
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is read-only");
        }
    }
}

