/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.util.Comparator;
import java.util.Set;
import org.magicwerk.brownies.collections.BigList;
import org.magicwerk.brownies.collections.CollectionAsSet;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.KeyCollectionImpl;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.helper.Option;

public abstract class KeyListImpl<E>
extends IList<E> {
    KeyCollectionImpl<E> keyColl;
    IList<E> list;
    private static final boolean DEBUG_CHECK = false;

    private void debugCheck() {
        this.keyColl.debugCheck();
        assert (this.keyColl.keyList == this);
        assert (this.list.size() == this.keyColl.size() || this.keyColl.size() == 0 && this.keyColl.keyMaps == null);
    }

    KeyListImpl() {
    }

    protected KeyListImpl(boolean copy, KeyListImpl<E> that) {
        if (copy) {
            this.doAssign(that);
        }
    }

    @Override
    protected void doAssign(IList<E> that) {
        KeyListImpl list2 = (KeyListImpl)that;
        this.keyColl = list2.keyColl;
        this.list = list2.list;
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    public KeyListImpl<E> copy() {
        KeyListImpl copy = (KeyListImpl)super.clone();
        copy.initCopy(this);
        return copy;
    }

    public KeyListImpl<E> crop() {
        KeyListImpl crop = (KeyListImpl)super.clone();
        crop.initCrop(this);
        return crop;
    }

    void initCrop(KeyListImpl<E> that) {
        this.keyColl = new KeyCollectionImpl();
        this.keyColl.initCrop(that.keyColl);
        if (this.keyColl.keyList != null) {
            this.keyColl.keyList = this;
        }
        this.list = that.keyColl.keyMaps != null && that.keyColl.keyMaps[0] != null && that.list == that.keyColl.keyMaps[0].keysList ? this.keyColl.keyMaps[0].keysList : that.list.doCreate(-1);
    }

    void initCopy(KeyListImpl<E> that) {
        this.keyColl = new KeyCollectionImpl();
        this.keyColl.initCopy(that.keyColl);
        if (this.keyColl.keyList != null) {
            this.keyColl.keyList = this;
        }
        if (that.keyColl.keyMaps != null && that.keyColl.keyMaps[0] != null && that.list == that.keyColl.keyMaps[0].keysList) {
            this.list = this.keyColl.keyMaps[0].keysList;
        } else {
            this.list = that.list.doCreate(-1);
            this.list.addAll(that.list);
        }
    }

    @Override
    protected void doClone(IList<E> that) {
    }

    public Set<E> asSet() {
        return new CollectionAsSet(this, false);
    }

    public boolean isSorted() {
        return this.keyColl.isSorted();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    protected E doGet(int index) {
        return this.list.doGet(index);
    }

    @Override
    protected <T> void doGetAll(T[] array, int index, int len2) {
        this.list.doGetAll(array, index, len2);
    }

    @Override
    public boolean contains(Object elem) {
        if (this.keyColl.hasElemSet()) {
            return this.keyColl.contains(elem);
        }
        return super.contains(elem);
    }

    @Override
    public boolean add(E elem) {
        return super.add(elem);
    }

    public boolean addIf(E elem) {
        try {
            return super.add(elem);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void add(int index, E elem) {
        super.add(index, elem);
    }

    @Override
    public E set(int index, E elem) {
        return super.set(index, elem);
    }

    @Override
    public void clear() {
        this.keyColl.clear();
        this.list.clear();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.keyColl.maxSize != 0) {
            minCapacity = Math.min(minCapacity, this.keyColl.maxSize);
        }
        super.ensureCapacity(minCapacity);
    }

    @Override
    protected boolean doAdd(int index, E elem) {
        this.keyColl.checkElemAllowed(elem);
        if (this.keyColl.maxSize != 0 && this.size() >= this.keyColl.maxSize) {
            if (this.keyColl.movingWindow) {
                if (index == 0) {
                    return false;
                }
                if (index == -1) {
                    index = this.size();
                }
                this.doRemove(0);
                --index;
            } else {
                KeyCollectionImpl.errorMaxSize();
            }
        }
        if (this.keyColl.isSorted()) {
            if (index == -1 && (index = this.keyColl.binarySearchSorted(elem)) < 0) {
                index = -index - 1;
            }
            this.keyColl.addSorted(index, elem);
            if (!this.keyColl.isSortedByElem()) {
                this.list.doAdd(index, elem);
            }
        } else {
            this.keyColl.addUnsorted(elem);
            if (index == -1) {
                index = this.list.size();
            }
            this.list.doAdd(index, elem);
        }
        return true;
    }

    @Override
    protected E doSet(int index, E elem) {
        this.keyColl.checkElemAllowed(elem);
        E remove = this.doGet(index);
        if (this.keyColl.isSorted()) {
            this.keyColl.setSorted(index, elem, remove);
        } else {
            this.keyColl.remove(remove);
            try {
                this.keyColl.add(elem);
            }
            catch (RuntimeException e) {
                this.keyColl.add(remove);
                throw e;
            }
        }
        this.list.doSet(index, elem);
        return remove;
    }

    @Override
    protected E doRemove(int index) {
        E removed = this.list.get(index);
        this.keyColl.remove(removed);
        if (!this.keyColl.isSortedByElem()) {
            this.list.remove(index);
        }
        return removed;
    }

    @Override
    protected void doRemoveAll(int index, int len2) {
        if (this.keyColl.isSortedByElem()) {
            for (int i = 0; i < len2; ++i) {
                E removed = this.list.get(index);
                this.keyColl.remove(removed);
            }
        } else {
            for (int i = 0; i < len2; ++i) {
                E removed = this.list.get(index + i);
                this.keyColl.remove(removed);
            }
            this.list.doRemoveAll(index, len2);
        }
    }

    @Override
    protected E doReSet(int index, E elem) {
        return this.list.doReSet(index, elem);
    }

    @Override
    public int indexOf(Object elem) {
        if (this.keyColl.isSorted()) {
            return this.keyColl.indexOfSorted(elem);
        }
        return super.indexOf(elem);
    }

    public int indexOfKey(int keyIndex, Object key) {
        return this.indexOfKey(keyIndex, key, 0);
    }

    public int indexOfKey(int keyIndex, Object key, int start) {
        int size2 = this.size();
        for (int i = start; i < size2; ++i) {
            Object elemKey = this.keyColl.getKey(keyIndex, this.doGet(i));
            if (!KeyListImpl.equalsElem(elemKey, key)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(int keyIndex, Object key) {
        return this.indexOfKey(keyIndex, key) != -1;
    }

    public IFunction<E, Object> getKeyMapper(int keyIndex) {
        return this.keyColl.getKeyMapper(keyIndex);
    }

    public E getByKey(int keyIndex, Object key) {
        return this.keyColl.getByKey(keyIndex, key);
    }

    public GapList<E> getAllByKey(int keyIndex, Object key) {
        return this.keyColl.getAllByKey(keyIndex, key);
    }

    public int getCountByKey(int keyIndex, Object key) {
        return this.keyColl.getCountByKey(keyIndex, key);
    }

    protected E removeByKey(int keyIndex, Object key) {
        Option<E> removed = this.keyColl.doRemoveByKey(keyIndex, key);
        if (removed.hasValue()) {
            int index = this.list.indexOf(removed.getValue());
            if (index == -1) {
                KeyCollectionImpl.errorInvalidData();
            }
            this.list.doRemove(index);
        }
        return removed.getValueOrNull();
    }

    protected E putByKey(int keyIndex, E elem) {
        int index;
        if (keyIndex == 0 && (this.keyColl.keyMaps == null || this.keyColl.keyMaps[0] == null)) {
            index = this.indexOf(elem);
        } else {
            Object key = this.keyColl.getKey(keyIndex, elem);
            index = this.indexOfKey(keyIndex, key);
        }
        E replaced = null;
        if (index == -1) {
            this.doAdd(-1, elem);
        } else {
            replaced = this.doSet(index, elem);
        }
        return replaced;
    }

    protected GapList<E> removeAllByKey(int keyIndex, Object key) {
        GapList<E> removeds = this.keyColl.removeAllByKey(keyIndex, key);
        if (!(removeds.isEmpty() || this.keyColl.isSortedByElem() || this.list.removeAll((IList<?>)removeds))) {
            KeyCollectionImpl.errorInvalidData();
        }
        return removeds;
    }

    protected GapList<Object> getAllKeys(int keyIndex) {
        IFunction mapper = this.keyColl.getKeyMap((int)keyIndex).mapper;
        GapList<Object> list2 = GapList.create();
        for (Object obj : this) {
            list2.add(mapper.apply(obj));
        }
        return list2;
    }

    public Set<?> getDistinctKeys(int keyIndex) {
        return this.keyColl.getDistinctKeys(keyIndex);
    }

    @Override
    public <K> int binarySearch(int index, int len2, K key, Comparator<? super K> comparator) {
        return this.list.binarySearch(index, len2, key, comparator);
    }

    @Override
    public void sort(int index, int len2, Comparator<? super E> comparator) {
        if (this.keyColl.isSorted()) {
            if (this.keyColl.isSortedByElem() && GapList.equalsElem(comparator, this.keyColl.getElemSortComparator())) {
                return;
            }
            throw new IllegalArgumentException("Different comparator specified for sorted list");
        }
        this.list.sort(index, len2, comparator);
    }

    @Override
    public IList<E> getAll(E elem) {
        if (this.keyColl.hasElemSet()) {
            return this.getAllByKey(0, elem);
        }
        return this.list.getAll(elem);
    }

    @Override
    public int getCount(E elem) {
        if (this.keyColl.hasElemSet()) {
            return this.getCountByKey(0, elem);
        }
        return this.list.getCount(elem);
    }

    @Override
    public IList<E> removeAll(E elem) {
        if (this.keyColl.hasElemSet()) {
            return this.removeAllByKey(0, elem);
        }
        return this.list.removeAll(elem);
    }

    @Override
    public Set<E> getDistinct() {
        if (this.keyColl.hasElemSet()) {
            return this.getDistinctKeys(0);
        }
        return super.getDistinct();
    }

    protected E put(E elem) {
        int index = this.indexOf(elem);
        if (index != -1) {
            return this.set(index, elem);
        }
        this.add(elem);
        return null;
    }

    protected void invalidate(E elem) {
        int newIndex;
        int oldIndex;
        this.keyColl.invalidate(elem);
        if (this.keyColl.isSorted() && !this.keyColl.isSortedByElem() && (oldIndex = super.indexOf(elem)) != (newIndex = this.keyColl.indexOfSorted(elem))) {
            this.list.doRemove(oldIndex);
            if (oldIndex < newIndex) {
                --newIndex;
            }
            this.list.doAdd(newIndex, elem);
        }
    }

    protected void invalidateKey(int keyIndex, Object oldKey, Object newKey, E elem) {
        elem = this.keyColl.doInvalidateKey(keyIndex, oldKey, newKey, elem);
        if (this.keyColl.orderByKey == keyIndex && this.list != null) {
            this.list.doRemove(super.indexOf(elem));
            int index = this.keyColl.indexOfSorted(elem);
            this.list.doAdd(index, elem);
        }
    }

    @Override
    protected E getDefaultElem() {
        return null;
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    protected IList<E> doCreate(int capacity) {
        if (this.list instanceof BigList) {
            return new BigList(capacity);
        }
        return new GapList(capacity);
    }
}

