/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0004\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 82\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u0011\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010$\u001a\u00020%2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010&\u001a\u00020\u0000J\b\u0010'\u001a\u00020\u0013H\u0016J\u0006\u0010(\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010*\u001a\u00020\u0000J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000fJ\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.H\u0007J\u0006\u0010/\u001a\u00020\u0000J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0003J\u000e\u00102\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0003J\u000e\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0000J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u0016\u00105\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\b\u00106\u001a\u000207H\u0016R\u001b\u0010\u0006\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00038GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\n\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0019\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015\u00a8\u00069"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "", "x", "", "y", "(DD)V", "len", "getLen", "()D", "len$delegate", "Lkotlin/Lazy;", "lengthSquared", "lengthSquared$delegate", "getX", "xf", "", "getXf", "()F", "xi", "", "getXi", "()I", "getY", "yf", "getYf", "yi", "getYi", "add", "other", "otherX", "otherY", "ceil", "divide", "amount", "dot", "point", "equals", "", "floor", "hashCode", "length", "mul", "normalize", "projectOnTo", "rotate", "theta", "", "round", "setX", "value", "setY", "squareDist", "vec", "sub", "toString", "", "Companion", "librarianlib-1.12.2"})
public final class Vec2d {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final transient float xf;
    private final transient float yf;
    private final transient int xi;
    private final transient int yi;
    @NotNull
    private final transient Lazy lengthSquared$delegate;
    private final transient Lazy len$delegate;
    private final double x;
    private final double y;
    @JvmField
    @NotNull
    public static final Vec2d ZERO;
    @JvmField
    @NotNull
    public static final Vec2d INFINITY;
    @JvmField
    @NotNull
    public static final Vec2d NEG_INFINITY;
    @JvmField
    @NotNull
    public static final Vec2d ONE;
    @JvmField
    @NotNull
    public static final Vec2d X;
    @JvmField
    @NotNull
    public static final Vec2d Y;
    @JvmField
    @NotNull
    public static final Vec2d X_INFINITY;
    @JvmField
    @NotNull
    public static final Vec2d Y_INFINITY;
    @JvmField
    @NotNull
    public static final Vec2d NEG_ONE;
    @JvmField
    @NotNull
    public static final Vec2d NEG_X;
    @JvmField
    @NotNull
    public static final Vec2d NEG_Y;
    @JvmField
    @NotNull
    public static final Vec2d NEG_X_INFINITY;
    @JvmField
    @NotNull
    public static final Vec2d NEG_Y_INFINITY;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Vec2d.class), "lengthSquared", "lengthSquared()D")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Vec2d.class), "len", "getLen()D"))};
        Companion = new Companion(null);
        ZERO = new Vec2d(0.0, 0.0);
        INFINITY = new Vec2d(DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY());
        NEG_INFINITY = new Vec2d(DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY(), DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY());
        ONE = new Vec2d(1.0, 1.0);
        X = new Vec2d(1.0, 0.0);
        Y = new Vec2d(0.0, 1.0);
        X_INFINITY = new Vec2d(DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), 0.0);
        Y_INFINITY = new Vec2d(0.0, DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
        NEG_ONE = new Vec2d(-1.0, -1.0);
        NEG_X = new Vec2d(-1.0, 0.0);
        NEG_Y = new Vec2d(0.0, -1.0);
        NEG_X_INFINITY = new Vec2d(DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY(), 0.0);
        NEG_Y_INFINITY = new Vec2d(0.0, DoubleCompanionObject.INSTANCE.getNEGATIVE_INFINITY());
    }

    public final float getXf() {
        return this.xf;
    }

    public final float getYf() {
        return this.yf;
    }

    public final int getXi() {
        return this.xi;
    }

    public final int getYi() {
        return this.yi;
    }

    @NotNull
    public final Vec2d floor() {
        return new Vec2d(Math.floor(this.x), Math.floor(this.y));
    }

    @NotNull
    public final Vec2d ceil() {
        return new Vec2d(Math.ceil(this.x), Math.ceil(this.y));
    }

    @NotNull
    public final Vec2d round() {
        return new Vec2d(Math.round(this.x), Math.round(this.y));
    }

    @NotNull
    public final Vec2d setX(double value) {
        return new Vec2d(value, this.y);
    }

    @NotNull
    public final Vec2d setY(double value) {
        return new Vec2d(this.x, value);
    }

    @NotNull
    public final Vec2d add(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vec2d(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vec2d add(double otherX, double otherY) {
        return new Vec2d(this.x + otherX, this.y + otherY);
    }

    @NotNull
    public final Vec2d sub(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vec2d(this.x - other.x, this.y - other.y);
    }

    @NotNull
    public final Vec2d sub(double otherX, double otherY) {
        return new Vec2d(this.x - otherX, this.y - otherY);
    }

    @NotNull
    public final Vec2d mul(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vec2d(this.x * other.x, this.y * other.y);
    }

    @NotNull
    public final Vec2d mul(double otherX, double otherY) {
        return new Vec2d(this.x * otherX, this.y * otherY);
    }

    @NotNull
    public final Vec2d mul(double amount) {
        return new Vec2d(this.x * amount, this.y * amount);
    }

    @NotNull
    public final Vec2d divide(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vec2d(this.x / other.x, this.y / other.y);
    }

    @NotNull
    public final Vec2d divide(double otherX, double otherY) {
        return new Vec2d(this.x / otherX, this.y / otherY);
    }

    @NotNull
    public final Vec2d divide(double amount) {
        return new Vec2d(this.x / amount, this.y / amount);
    }

    public final double dot(@NotNull Vec2d point) {
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        return this.x * point.x + this.y * point.y;
    }

    @JvmName(name="lengthSquared")
    public final double lengthSquared() {
        Lazy lazy2 = this.lengthSquared$delegate;
        Vec2d vec2d = this;
        KProperty kProperty = $$delegatedProperties[0];
        return ((Number)lazy2.getValue()).doubleValue();
    }

    private final double getLen() {
        Lazy lazy2 = this.len$delegate;
        Vec2d vec2d = this;
        KProperty kProperty = $$delegatedProperties[1];
        return ((Number)lazy2.getValue()).doubleValue();
    }

    public final double length() {
        return this.getLen();
    }

    @NotNull
    public final Vec2d normalize() {
        double norm = this.length();
        return new Vec2d(this.x / norm, this.y / norm);
    }

    public final double squareDist(@NotNull Vec2d vec) {
        Intrinsics.checkParameterIsNotNull((Object)vec, (String)"vec");
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        return d0 * d0 + d1 * d1;
    }

    @NotNull
    public final Vec2d projectOnTo(@NotNull Vec2d other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Vec2d norm = other.normalize();
        return norm.mul(this.dot(norm));
    }

    @NotNull
    public final Vec2d rotate(float theta) {
        if (theta == 0.0f) {
            return this;
        }
        float cs = MathHelper.func_76134_b((float)theta);
        float sn = MathHelper.func_76126_a((float)theta);
        return new Vec2d(this.x * (double)cs - this.y * (double)sn, this.x * (double)sn + this.y * (double)cs);
    }

    @Deprecated(message="Deprecated for boxing reasons. Use the primitive version instead.", replaceWith=@ReplaceWith(imports={}, expression="this.rotate(theta.toFloat())"))
    @NotNull
    public final Vec2d rotate(@NotNull Number theta) {
        Intrinsics.checkParameterIsNotNull((Object)theta, (String)"theta");
        return this.rotate(theta.floatValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        return this.x == ((Vec2d)other).x && this.y == ((Vec2d)other).y;
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.x + ',' + this.y + ')';
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Vec2d(double x2, double y) {
        this.x = x2;
        this.y = y;
        this.xf = (float)this.x;
        this.yf = (float)this.y;
        this.xi = (int)Math.floor(this.x);
        this.yi = (int)Math.floor(this.y);
        this.lengthSquared$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ Vec2d this$0;

            public final double invoke() {
                return this.this$0.getX() * this.this$0.getX() + this.this$0.getY() * this.this$0.getY();
            }
            {
                this.this$0 = vec2d;
                super(0);
            }
        }));
        this.len$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ Vec2d this$0;

            public final double invoke() {
                return Math.sqrt(this.this$0.lengthSquared());
            }
            {
                this.this$0 = vec2d;
                super(0);
            }
        }));
    }

    @JvmStatic
    @NotNull
    public static final Vec2d min(@NotNull Vec2d a, @NotNull Vec2d b) {
        return Companion.min(a, b);
    }

    @JvmStatic
    @NotNull
    public static final Vec2d max(@NotNull Vec2d a, @NotNull Vec2d b) {
        return Companion.max(a, b);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Vec2d$Companion;", "", "()V", "INFINITY", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "NEG_INFINITY", "NEG_ONE", "NEG_X", "NEG_X_INFINITY", "NEG_Y", "NEG_Y_INFINITY", "ONE", "X", "X_INFINITY", "Y", "Y_INFINITY", "ZERO", "max", "a", "b", "min", "librarianlib-1.12.2"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Vec2d min(@NotNull Vec2d a, @NotNull Vec2d b) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            return new Vec2d(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()));
        }

        @JvmStatic
        @NotNull
        public final Vec2d max(@NotNull Vec2d a, @NotNull Vec2d b) {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
            return new Vec2d(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

