/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.util.crafting.ingredient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.pau101.fairylights.util.crafting.GenericRecipe;
import com.pau101.fairylights.util.crafting.ingredient.IngredientAuxiliary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public abstract class IngredientAuxiliaryList<A>
implements IngredientAuxiliary<A> {
    protected final List<? extends IngredientAuxiliary<?>> ingredients;
    protected final boolean isRequired;
    protected final int limit;

    public IngredientAuxiliaryList(boolean isRequired, int limit, IngredientAuxiliary<?> ... ingredients) {
        this(Arrays.asList(ingredients), isRequired, limit);
    }

    public IngredientAuxiliaryList(boolean isRequired, IngredientAuxiliary<?> ... ingredients) {
        this(Arrays.asList(ingredients), isRequired, Integer.MAX_VALUE);
    }

    public IngredientAuxiliaryList(List<? extends IngredientAuxiliary<?>> ingredients, boolean isRequired, int limit) {
        Objects.requireNonNull(ingredients, "ingredients");
        Preconditions.checkArgument((ingredients.size() > 0 ? 1 : 0) != 0, (Object)"ingredients must have at least one element");
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be greater than zero");
        this.ingredients = ingredients;
        this.isRequired = isRequired;
        this.limit = limit;
    }

    @Override
    public final GenericRecipe.MatchResultAuxiliary matches(ItemStack input, ItemStack output) {
        GenericRecipe.MatchResultAuxiliary matchResult = null;
        ArrayList<GenericRecipe.MatchResultAuxiliary> supplementaryResults = new ArrayList<GenericRecipe.MatchResultAuxiliary>(this.ingredients.size());
        for (IngredientAuxiliary<?> ingredient : this.ingredients) {
            GenericRecipe.MatchResultAuxiliary result = (GenericRecipe.MatchResultAuxiliary)ingredient.matches(input, output);
            if (result.doesMatch() && matchResult == null) {
                matchResult = result;
                continue;
            }
            supplementaryResults.add(result);
        }
        if (matchResult == null) {
            return new GenericRecipe.MatchResultAuxiliary(this, input, false, supplementaryResults);
        }
        return matchResult.withParent(new GenericRecipe.MatchResultAuxiliary(this, input, true, supplementaryResults));
    }

    @Override
    public ImmutableList<ItemStack> getInputs() {
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (IngredientAuxiliary<?> ingredient : this.ingredients) {
            inputs.addAll(ingredient.getInputs());
        }
        return inputs.build();
    }

    @Override
    public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
        ArrayList inputs = new ArrayList();
        for (IngredientAuxiliary<?> ingredient : this.ingredients) {
            ImmutableList<ImmutableList<ItemStack>> immutableList = ingredient.getInput(output);
            for (int i = 0; i < immutableList.size(); ++i) {
                ArrayList stacks;
                if (i < inputs.size()) {
                    stacks = (ArrayList)inputs.get(i);
                } else {
                    stacks = new ArrayList();
                    inputs.add(stacks);
                }
                stacks.addAll((Collection)immutableList.get(i));
            }
        }
        ImmutableList.Builder inputsImm = ImmutableList.builder();
        for (List list : inputs) {
            inputsImm.add((Object)ImmutableList.copyOf((Collection)list));
        }
        return inputsImm.build();
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean process(Multimap<IngredientAuxiliary<?>, GenericRecipe.MatchResultAuxiliary> map, ItemStack output) {
        for (IngredientAuxiliary<?> ingredient : this.ingredients) {
            if (!ingredient.process(map, output)) continue;
            return true;
        }
        return IngredientAuxiliary.super.process(map, output);
    }

    public String toString() {
        return this.ingredients.toString();
    }
}

