/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.jingle;

import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import com.pau101.fairylights.server.jingle.Jingle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;

public class JingleLibrary {
    private static final String UNKNOWN_ID = "";
    private static final RegistryNamespacedDefaultedByKey<String, JingleLibrary> REGISTRY = new RegistryNamespacedDefaultedByKey((Object)"");
    private static final JingleLibrary UNKNOWN = JingleLibrary.register(new JingleLibrary(""){

        @Override
        public void load() {
        }
    });
    private static final int MAX_RANGE = 25;
    private static int nextFeatureId;
    private final String name;
    private final Map<String, Jingle> jingles = new HashMap<String, Jingle>();
    private final Multimap<Integer, Jingle> jinglesWithinRange = ArrayListMultimap.create();
    private final Map<Integer, Integer> rangeWeights = new HashMap<Integer, Integer>();

    private JingleLibrary(String name) {
        this.name = name;
    }

    public int getId() {
        return REGISTRY.func_148757_b((Object)this);
    }

    public boolean contains(String id) {
        return this.jingles.containsKey(id);
    }

    @Nullable
    public Jingle get(String id) {
        return this.jingles.get(id);
    }

    private void put(String id, Jingle jingle) {
        this.jingles.put(id, jingle);
        for (int range = jingle.getRange(); range <= 25; ++range) {
            this.jinglesWithinRange.put((Object)range, (Object)jingle);
            this.rangeWeights.merge(range, jingle.getRange(), Math::addExact);
        }
    }

    @Nullable
    public synchronized Jingle getRandom(Random rng, int range) {
        int fitRange = Math.min(range, 25);
        Collection jingles = this.jinglesWithinRange.get((Object)fitRange);
        if (jingles.isEmpty()) {
            return null;
        }
        float choice = rng.nextFloat() * (float)this.rangeWeights.get(fitRange).intValue();
        for (Jingle jingle : jingles) {
            if (!((choice -= (float)jingle.getRange()) <= 0.0f)) continue;
            return jingle;
        }
        return null;
    }

    public void load() {
        InputStream in = null;
        try {
            in = MinecraftServer.class.getResourceAsStream("/assets/fairylights/jingles/" + this.name + ".dat");
            this.deserialize(CompressedStreamTools.func_74796_a((InputStream)in));
            Closeables.closeQuietly((InputStream)in);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly(in);
        }
    }

    private synchronized void deserialize(NBTTagCompound library) {
        this.jingles.clear();
        this.jinglesWithinRange.clear();
        this.rangeWeights.clear();
        for (String id : library.func_150296_c()) {
            NBTTagCompound jingleCompound = library.func_74775_l(id);
            Jingle jingle = Jingle.from(jingleCompound);
            if (!jingle.isValid() || this.contains(jingle.getId())) continue;
            this.put(jingle.getId(), jingle);
        }
    }

    public static JingleLibrary create(String name) {
        return JingleLibrary.register(new JingleLibrary(name));
    }

    private static JingleLibrary register(JingleLibrary library) {
        REGISTRY.func_177775_a(nextFeatureId++, (Object)library.name, (Object)library);
        return library;
    }

    public static JingleLibrary fromId(int id) {
        return (JingleLibrary)REGISTRY.func_148754_a(id);
    }

    public static void loadAll() {
        Iterator iter = REGISTRY.iterator();
        while (iter.hasNext()) {
            ((JingleLibrary)iter.next()).load();
        }
    }
}

