/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.type.letter;

import com.google.common.base.MoreObjects;
import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.client.gui.GuiEditLetteredConnection;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.Catenary;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.PlayerAction;
import com.pau101.fairylights.server.fastener.connection.Segment;
import com.pau101.fairylights.server.fastener.connection.collision.Intersection;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.fastener.connection.type.Lettered;
import com.pau101.fairylights.server.fastener.connection.type.letter.Letter;
import com.pau101.fairylights.server.fastener.connection.type.letter.SymbolSet;
import com.pau101.fairylights.server.net.clientbound.MessageOpenEditLetteredConnectionGUI;
import com.pau101.fairylights.util.styledstring.StyledString;
import com.pau101.fairylights.util.styledstring.StylingPresence;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ConnectionLetterBunting
extends Connection
implements Lettered {
    public static final SymbolSet SYMBOLS = SymbolSet.from(6, 10, "0,6,1,3,2,6,3,6,4,6,5,6,6,6,7,6,8,6,9,6,A,8,B,7,C,8,D,7,E,7,F,7,G,8,H,7,I,2,J,6,K,8,L,7,M,10,N,8,O,8,P,7,Q,8,R,7,S,7,T,8,U,7,V,8,W,10,X,8,Y,8,Z,7, ,6");
    private static final float TRACKING = 2.0f;
    private static final StylingPresence SUPPORTED_STYLING = new StylingPresence(true, false, false, false, false, false);
    private StyledString text;
    private Letter[] letters = new Letter[0];
    private Letter[] prevLetters;

    public ConnectionLetterBunting(World world, Fastener<?> fastener, UUID uuid, Fastener<?> destination, boolean isOrigin, NBTTagCompound compound) {
        super(world, fastener, uuid, destination, isOrigin, compound);
    }

    public ConnectionLetterBunting(World world, Fastener<?> fastener, UUID uuid) {
        super(world, fastener, uuid);
        this.text = new StyledString();
    }

    @Override
    public float getRadius() {
        return 0.028125f;
    }

    public Letter[] getLetters() {
        return this.letters;
    }

    public Letter[] getPrevLetters() {
        return (Letter[])MoreObjects.firstNonNull((Object)this.prevLetters, (Object)this.letters);
    }

    @Override
    public ConnectionType getType() {
        return ConnectionType.LETTER_BUNTING;
    }

    @Override
    public void processClientAction(EntityPlayer player, PlayerAction action, Intersection intersection) {
        if (this.openTextGui(player, action, intersection)) {
            super.processClientAction(player, action, intersection);
        }
    }

    @Override
    public void onConnect(World world, EntityPlayer user, ItemStack heldStack) {
        if (this.text.isEmpty()) {
            FairyLights.network.sendTo(new MessageOpenEditLetteredConnectionGUI<ConnectionLetterBunting>(this), (EntityPlayerMP)user);
        }
    }

    @Override
    protected void onUpdateEarly() {
        this.prevLetters = this.letters;
        for (Letter letter : this.letters) {
            letter.tick();
        }
    }

    @Override
    protected void onCalculateCatenary() {
        this.updateLetters();
    }

    private void updateLetters() {
        if (this.text.isEmpty()) {
            this.prevLetters = this.letters;
            this.letters = new Letter[0];
        } else {
            Catenary catenary = this.getCatenary();
            float textWidth = 0.0f;
            int textLen = 0;
            float[] pointOffsets = new float[this.text.length()];
            float catLength = catenary.getLength();
            for (int i = 0; i < this.text.length(); ++i) {
                float w = SYMBOLS.getWidth(this.text.charAt(i));
                pointOffsets[i] = textWidth + w / 2.0f;
                if ((textWidth += w + 2.0f) > catLength) break;
                ++textLen;
            }
            float offset = catLength / 2.0f - textWidth / 2.0f;
            int i = 0;
            while (i < textLen) {
                int n = i++;
                pointOffsets[n] = pointOffsets[n] + offset;
            }
            int pointIdx = 0;
            this.prevLetters = this.letters;
            boolean hasPrevLetters = this.prevLetters != null;
            ArrayList<Letter> letters = new ArrayList<Letter>(this.text.length());
            Segment[] segments = catenary.getSegments();
            double distance = 0.0;
            for (int i2 = 0; i2 < segments.length; ++i2) {
                float pointOffset;
                Segment seg = segments[i2];
                double length = seg.getLength();
                for (int n = pointIdx; n < textLen && (double)(pointOffset = pointOffsets[n]) < distance + length; ++n) {
                    double t = ((double)pointOffset - distance) / length;
                    Vec3d point = seg.pointAt(t);
                    Letter letter = new Letter(pointIdx, point, seg.getRotation(), SYMBOLS, this.text.charAt(pointIdx));
                    if (hasPrevLetters && pointIdx < this.prevLetters.length) {
                        letter.inherit(this.prevLetters[pointIdx]);
                    }
                    letters.add(letter);
                    ++pointIdx;
                }
                if (pointIdx == textLen) break;
                distance += length;
            }
            this.letters = letters.toArray(new Letter[letters.size()]);
        }
    }

    @Override
    public StylingPresence getSupportedStyling() {
        return SUPPORTED_STYLING;
    }

    @Override
    public boolean isSupportedCharacter(char chr) {
        return SYMBOLS.contains(chr);
    }

    @Override
    public boolean isSuppportedText(StyledString text) {
        float len = 0.0f;
        float available = this.getCatenary().getLength();
        for (int i = 0; i < text.length(); ++i) {
            float w = SYMBOLS.getWidth(text.charAt(i));
            if ((len += w + 2.0f) > available) {
                return false;
            }
            if (text.styleAt(i).isPlain()) continue;
            return false;
        }
        return Lettered.super.isSuppportedText(text);
    }

    @Override
    public void setText(StyledString text) {
        this.text = text;
        this.dataUpdateState = true;
    }

    @Override
    public StyledString getText() {
        return this.text;
    }

    @Override
    public Function<Character, Character> getCharInputTransformer() {
        return Character::toUpperCase;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen createTextGUI() {
        return new GuiEditLetteredConnection<ConnectionLetterBunting>(this);
    }

    @Override
    public NBTTagCompound serializeLogic() {
        NBTTagCompound compound = super.serializeLogic();
        compound.func_74782_a("text", (NBTBase)StyledString.serialize(this.text));
        return compound;
    }

    @Override
    public void deserializeLogic(NBTTagCompound compound) {
        super.deserializeLogic(compound);
        this.text = StyledString.deserialize(compound.func_74775_l("text"));
    }
}

