/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.ServerProxy;
import com.pau101.fairylights.server.block.BlockFastener;
import com.pau101.fairylights.server.block.FLBlocks;
import com.pau101.fairylights.server.block.entity.BlockEntityFastener;
import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.config.Configurator;
import com.pau101.fairylights.server.entity.EntityFenceFastener;
import com.pau101.fairylights.server.entity.EntityLadder;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.FastenerBlock;
import com.pau101.fairylights.server.fastener.FastenerFence;
import com.pau101.fairylights.server.fastener.FastenerPlayer;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.ConnectionHangingLights;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.Light;
import com.pau101.fairylights.server.item.ItemConnection;
import com.pau101.fairylights.server.jingle.Jingle;
import com.pau101.fairylights.server.jingle.JingleLibrary;
import com.pau101.fairylights.server.net.clientbound.MessageJingle;
import com.pau101.fairylights.server.net.clientbound.MessageUpdateFastenerEntity;
import com.pau101.fairylights.server.sound.FLSounds;
import com.pau101.fairylights.server.world.ServerWorldEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockAction;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class ServerEventHandler {
    private final Random rng = new Random();
    private float jingleProbability = 1.6666666E-4f;

    @SubscribeEvent
    public void onGetCollisionBoxes(GetCollisionBoxesEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            AxisAlignedBB bounds = event.getAabb();
            List ladders = event.getWorld().func_72872_a(EntityLadder.class, bounds.func_186662_g(1.0));
            List boxes = event.getCollisionBoxesList();
            for (EntityLadder ladder : ladders) {
                if (entity == ladder) continue;
                List<AxisAlignedBB> surfaces = ladder.getCollisionSurfaces();
                for (AxisAlignedBB surface : surfaces) {
                    if (!surface.func_72326_a(bounds)) continue;
                    boxes.add(surface);
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            world.func_72954_a((IWorldEventListener)new ServerWorldEventListener());
        }
    }

    @SubscribeEvent
    public void onAttachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityPlayer) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new FastenerPlayer((EntityPlayer)entity));
        } else if (entity instanceof EntityFenceFastener) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new FastenerFence((EntityFenceFastener)entity));
        }
    }

    @SubscribeEvent
    public void onAttachBlockEntityCapability(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity entity = (TileEntity)event.getObject();
        if (entity instanceof BlockEntityFastener) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new FastenerBlock((BlockEntityFastener)entity, ServerProxy.buildBlockView()));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        Fastener fastener;
        if (event.phase == TickEvent.Phase.END && (fastener = (Fastener)event.player.getCapability(CapabilityHandler.FASTENER_CAP, null)).update() && !event.player.field_70170_p.field_72995_K) {
            ServerProxy.sendToPlayersWatchingEntity(new MessageUpdateFastenerEntity((Entity)event.player, fastener.serializeNBT()), event.player.field_70170_p, (Entity)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onNoteBlockPlay(NoteBlockEvent.Play event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Block noteBlock = world.func_180495_p(pos).func_177230_c();
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        if (below.func_177230_c() == FLBlocks.FASTENER && below.func_177229_b((IProperty)BlockFastener.FACING) == EnumFacing.DOWN) {
            int note = event.getVanillaNoteId();
            float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
            world.func_184133_a(null, pos, FLSounds.JINGLE_BELL, SoundCategory.RECORDS, 3.0f, pitch);
            world.func_175688_a(EnumParticleTypes.NOTE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, (double)note / 24.0, 0.0, 0.0, new int[0]);
            if (!world.field_72995_K) {
                SPacketBlockAction pkt = new SPacketBlockAction(pos, noteBlock, event.getInstrument().ordinal(), note);
                PlayerList players = ((WorldServer)world).func_73046_m().func_184103_al();
                players.func_148543_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0, world.field_73011_w.getDimension(), (Packet)pkt);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityHanging entity;
        ItemStack offhandStack;
        BlockPos pos;
        World world = event.getWorld();
        if (!(world.func_180495_p(pos = event.getPos()).func_177230_c() instanceof BlockFence)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        boolean checkHanging = stack.func_77973_b() == Items.field_151058_ca;
        EntityPlayer player = event.getEntityPlayer();
        if (event.getHand() == EnumHand.MAIN_HAND && (offhandStack = player.func_184592_cb()).func_77973_b() instanceof ItemConnection) {
            if (checkHanging) {
                event.setCanceled(true);
                return;
            }
            event.setUseBlock(Event.Result.DENY);
        }
        if (!checkHanging && !world.field_72995_K) {
            double range = 7.0;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            AxisAlignedBB area = new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0);
            for (EntityLiving entity2 : world.func_72872_a(EntityLiving.class, area)) {
                if (!entity2.func_110167_bD() || entity2.func_110166_bE() != player) continue;
                checkHanging = true;
                break;
            }
        }
        if (checkHanging && (entity = EntityFenceFastener.findHanging(world, pos)) != null && !(entity instanceof EntityLeashKnot)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (FairyLights.christmas.isOcurringNow() && Configurator.isJingleEnabled() && this.rng.nextFloat() < this.jingleProbability) {
            Connection connection;
            List connections;
            Fastener fastener;
            Fastener fastener2;
            List<Vec3d> newPlayingSources;
            List tileEntities = event.world.field_147482_g;
            ArrayList<Vec3d> playingSources = new ArrayList<Vec3d>();
            HashMap feasibleConnections = new HashMap();
            for (TileEntity tileEntity : tileEntities) {
                if (!tileEntity.hasCapability(CapabilityHandler.FASTENER_CAP, null) || (newPlayingSources = this.getPlayingLightSources(event.world, feasibleConnections, fastener2 = (Fastener)tileEntity.getCapability(CapabilityHandler.FASTENER_CAP, null))) == null || newPlayingSources.size() <= 0) continue;
                playingSources.addAll(newPlayingSources);
            }
            for (Entity entity : event.world.field_72996_f) {
                if (!entity.hasCapability(CapabilityHandler.FASTENER_CAP, null) || (newPlayingSources = this.getPlayingLightSources(event.world, feasibleConnections, fastener2 = (Fastener)entity.getCapability(CapabilityHandler.FASTENER_CAP, null))) == null || newPlayingSources.size() <= 0) continue;
                playingSources.addAll(newPlayingSources);
            }
            Iterator feasibleFasteners = feasibleConnections.keySet().iterator();
            while (feasibleFasteners.hasNext()) {
                fastener = (Fastener)feasibleFasteners.next();
                connections = (List)feasibleConnections.get(fastener);
                Iterator connectionIterator = connections.iterator();
                while (connectionIterator.hasNext()) {
                    connection = (Connection)((Map.Entry)connectionIterator.next()).getValue();
                    if (!this.isTooCloseTo(fastener, (Light[])((ConnectionHangingLights)connection).getFeatures(), playingSources)) continue;
                    connectionIterator.remove();
                }
                if (connections.size() != 0) continue;
                feasibleFasteners.remove();
            }
            if (feasibleConnections.size() == 0) {
                return;
            }
            fastener = feasibleConnections.keySet().toArray(new Fastener[0])[this.rng.nextInt(feasibleConnections.size())];
            connections = (List)feasibleConnections.get(fastener);
            Map.Entry connectionEntry = (Map.Entry)connections.get(this.rng.nextInt(connections.size()));
            connection = (Connection)connectionEntry.getValue();
            ServerEventHandler.tryJingle(event.world, connection, (ConnectionHangingLights)connection, FairyLights.christmasJingles);
        }
    }

    private List<Vec3d> getPlayingLightSources(World world, Map<Fastener<?>, List<Map.Entry<UUID, Connection>>> feasibleConnections, Fastener<?> fastener) {
        ArrayList<Vec3d> points = new ArrayList<Vec3d>();
        double expandAmount = Configurator.getJingleAmplitude();
        AxisAlignedBB listenerRegion = fastener.getBounds().func_72321_a(expandAmount, expandAmount, expandAmount);
        List nearPlayers = fastener.getWorld().func_72872_a(EntityPlayer.class, listenerRegion);
        boolean arePlayersNear = nearPlayers.size() > 0;
        for (Map.Entry<UUID, Connection> connectionEntry : fastener.getConnections().entrySet()) {
            Connection connection = connectionEntry.getValue();
            if (!connection.isOrigin() || !connection.getDestination().isLoaded(world) || connection.getType() != ConnectionType.HANGING_LIGHTS) continue;
            ConnectionHangingLights connectionLogic = (ConnectionHangingLights)connection;
            Light[] lightPoints = (Light[])connectionLogic.getFeatures();
            if (connectionLogic.canCurrentlyPlayAJingle()) {
                if (!arePlayersNear) continue;
                if (feasibleConnections.containsKey(fastener)) {
                    feasibleConnections.get(fastener).add(connectionEntry);
                    continue;
                }
                ArrayList<Map.Entry<UUID, Connection>> connections = new ArrayList<Map.Entry<UUID, Connection>>();
                connections.add(connectionEntry);
                feasibleConnections.put(fastener, connections);
                continue;
            }
            for (Light light : lightPoints) {
                points.add(light.getAbsolutePoint(fastener));
            }
        }
        return points;
    }

    public boolean isTooCloseTo(Fastener fastener, Light[] lights, List<Vec3d> playingSources) {
        for (Light light : lights) {
            for (Vec3d point : playingSources) {
                if (!(light.getAbsolutePoint(fastener).func_72438_d(point) <= (double)Configurator.getJingleAmplitude())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean tryJingle(World world, Connection connection, ConnectionHangingLights hangingLights, JingleLibrary library) {
        Light[] lights = (Light[])hangingLights.getFeatures();
        Jingle jingle = library.getRandom(world.field_73012_v, lights.length);
        if (jingle != null) {
            int lightOffset = lights.length / 2 - jingle.getRange() / 2;
            hangingLights.play(library, jingle, lightOffset);
            ServerProxy.sendToPlayersWatchingChunk(new MessageJingle(connection, lightOffset, library, jingle), world, connection.getFastener().getPos());
            return true;
        }
        return false;
    }
}

