/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model.connection;

import com.pau101.fairylights.client.model.AdvancedModelRenderer;
import com.pau101.fairylights.client.model.RotationOrder;
import com.pau101.fairylights.client.model.connection.ModelConnection;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.type.pennant.ConnectionPennantBunting;
import com.pau101.fairylights.server.fastener.connection.type.pennant.Pennant;
import com.pau101.fairylights.util.Mth;
import com.pau101.fairylights.util.styledstring.StyledString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ModelConnectionPennantBunting
extends ModelConnection<ConnectionPennantBunting> {
    private AdvancedModelRenderer cordModel;
    private AdvancedModelRenderer[] pennantModels = new AdvancedModelRenderer[]{this.createPennant(63), this.createPennant(72), this.createPennant(81)};

    public ModelConnectionPennantBunting() {
        this.cordModel = new AdvancedModelRenderer(this, 0, 17);
        this.cordModel.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 1);
        this.cordModel.scaleX = 1.5f;
        this.cordModel.scaleY = 1.5f;
    }

    private AdvancedModelRenderer createPennant(int u) {
        AdvancedModelRenderer pennant = new AdvancedModelRenderer(this, u, 16);
        pennant.add3DTexture(-4.5f, -10.0f, 0.5f, 9, 10);
        pennant.setRotationOrder(RotationOrder.YXZ);
        pennant.secondaryRotateAngleY = 1.5707964f;
        return pennant;
    }

    @Override
    public boolean hasTexturedRender() {
        return true;
    }

    @Override
    public void render(Fastener<?> fastener, ConnectionPennantBunting bunting, World world, int skylight, int moonlight, float delta) {
        super.render(fastener, bunting, world, skylight, moonlight, delta);
        Pennant[] pennants = (Pennant[])bunting.getFeatures();
        Pennant[] prevPennants = (Pennant[])bunting.getPrevFeatures();
        GlStateManager.func_179129_p();
        int count = Math.min(pennants.length, prevPennants.length);
        for (int i = 0; i < count; ++i) {
            AdvancedModelRenderer model = this.preparePennantModel(pennants, prevPennants, i, delta);
            int rgb = pennants[i].getColor();
            GlStateManager.func_179124_c((float)((float)(rgb >> 16 & 0xFF) / 255.0f), (float)((float)(rgb >> 8 & 0xFF) / 255.0f), (float)((float)(rgb & 0xFF) / 255.0f));
            model.func_78785_a(0.0625f);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderTexturePass(Fastener<?> fastener, ConnectionPennantBunting bunting, World world, int skylight, int moonlight, float delta) {
        int offset;
        Pennant[] pennants = (Pennant[])bunting.getFeatures();
        Pennant[] prevPennants = (Pennant[])bunting.getPrevFeatures();
        StyledString text = bunting.getText();
        int pennantCount = Math.min(pennants.length, prevPennants.length);
        if (text.length() > pennantCount) {
            int over = text.length() - pennantCount;
            int lower = over / 2;
            text = text.substring(lower, text.length() - over + lower);
            offset = 0;
        } else {
            offset = pennantCount / 2 - text.length() / 2;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < text.length(); ++i) {
            int pennantIndex = i + offset;
            StyledString chrA = text.substring(i, i + 1);
            StyledString chrB = text.substring(text.length() - i - 1, text.length() - i);
            String charAStr = chrA.toString();
            String charBStr = chrB.toString();
            AdvancedModelRenderer model = this.preparePennantModel(pennants, prevPennants, pennantIndex, delta);
            GlStateManager.func_179094_E();
            model.func_78794_c(0.0625f);
            float s = 0.03075f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)-0.04f);
            GlStateManager.func_179152_a((float)(-s), (float)(-s), (float)s);
            GlStateManager.func_179109_b((float)((float)(-font.func_78256_a(charAStr)) / 2.0f + 0.5f), (float)-4.0f, (float)0.0f);
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
            font.func_78276_b(charAStr, 0, 0, -1);
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.04f);
            GlStateManager.func_179152_a((float)s, (float)(-s), (float)s);
            GlStateManager.func_179109_b((float)((float)(-font.func_78256_a(charBStr)) / 2.0f + 0.5f), (float)-4.0f, (float)0.0f);
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-1.0f);
            font.func_78276_b(charBStr, 0, 0, -1);
            GlStateManager.func_179121_F();
        }
    }

    private AdvancedModelRenderer preparePennantModel(Pennant[] pennants, Pennant[] prevPennants, int index, float delta) {
        Pennant pennant = pennants[index];
        Vec3d point = Mth.lerp(prevPennants[index].getPoint(), pennant.getPoint(), delta);
        Vec3d rotation = Mth.lerpAngles(prevPennants[index].getRotation(), pennant.getRotation(), delta);
        AdvancedModelRenderer model = this.pennantModels[index % this.pennantModels.length];
        model.setRotationPoint(point.field_72450_a, point.field_72448_b, point.field_72449_c);
        model.setRotationAngles(rotation.field_72448_b, rotation.field_72450_a, rotation.field_72449_c);
        return model;
    }

    @Override
    protected void renderSegment(ConnectionPennantBunting connection, int index, double angleX, double angleY, double length, double x, double y, double z, float delta) {
        this.cordModel.field_78795_f = (float)angleX;
        this.cordModel.field_78796_g = (float)angleY;
        this.cordModel.scaleZ = (float)length;
        this.cordModel.setRotationPoint(x, y, z);
        this.cordModel.func_78785_a(0.0625f);
    }
}

