/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.guide;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.GuideBook;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.BookBinder;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.category.CategoryItemStack;
import amerifrance.guideapi.entry.EntryItemStack;
import amerifrance.guideapi.page.PageIRecipe;
import amerifrance.guideapi.page.PageText;
import com.kjmaster.inventorygenerators.common.init.InitModGenerators;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@GuideBook
public class InventoryGenBook
implements IGuideBook {
    private static Book invGenGuideBook;
    private static String[] generatorStrings;
    private static String[] upgradeStrings;
    private static Item[] generators;
    private static Item[] upgrades;
    private static ShapedOreRecipe[] generatorRecipes;
    private static ShapedOreRecipe[] upgradeRecipes;

    @Nullable
    public Book buildBook() {
        LinkedHashMap<ResourceLocation, EntryItemStack> generatorEntries = new LinkedHashMap<ResourceLocation, EntryItemStack>();
        int i = 0;
        for (String generator : generatorStrings) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(new PageText(new TextComponentTranslation("info.invgens." + generator, new Object[0]).func_150260_c()));
            arrayList.add(new PageIRecipe((IRecipe)generatorRecipes[i]));
            generatorEntries.put(new ResourceLocation("inventorygenerators", "entry_" + i), new EntryItemStack(arrayList, new TextComponentTranslation("item.inv_" + generator + "_gen.name", new Object[0]).func_150260_c(), new ItemStack(generators[i])));
            ++i;
        }
        LinkedHashMap<ResourceLocation, EntryItemStack> upgradeEntries = new LinkedHashMap<ResourceLocation, EntryItemStack>();
        i = 0;
        for (String string : upgradeStrings) {
            ArrayList<Object> pages = new ArrayList<Object>();
            pages.add(new PageText(new TextComponentTranslation("info.invgens." + string, new Object[0]).func_150260_c()));
            pages.add(new PageIRecipe((IRecipe)upgradeRecipes[i]));
            upgradeEntries.put(new ResourceLocation("inventorygenerators", "entry_" + i), new EntryItemStack(pages, new TextComponentTranslation("item." + string + ".name", new Object[0]).func_150260_c(), new ItemStack(upgrades[i])));
            ++i;
        }
        ArrayList<CategoryItemStack> categories = new ArrayList<CategoryItemStack>();
        categories.add(new CategoryItemStack(generatorEntries, new TextComponentTranslation("itemGroup.invgens", new Object[0]).func_150260_c(), new ItemStack(InitModGenerators.invNetherStarGen)));
        categories.add(new CategoryItemStack(upgradeEntries, new TextComponentTranslation("container.upgrades", new Object[0]).func_150260_c(), new ItemStack(InitModGenerators.speedUpgrade)));
        BookBinder invGenGuideBinder = new BookBinder(new ResourceLocation("inventorygenerators", "guide_book"));
        invGenGuideBinder.setGuideTitle(new TextComponentTranslation("itemGroup.invgens", new Object[0]).func_150260_c());
        invGenGuideBinder.setItemName("itemGroup.invgens");
        invGenGuideBinder.setAuthor("kjmaster1");
        invGenGuideBinder.setColor(Color.GRAY);
        for (CategoryAbstract categoryAbstract : categories) {
            invGenGuideBinder.addCategory(categoryAbstract);
        }
        invGenGuideBook = invGenGuideBinder.build();
        return invGenGuideBook;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleModel(@Nonnull ItemStack bookStack) {
        GuideAPI.setModel((Book)invGenGuideBook);
    }

    public void handlePost(@Nonnull ItemStack bookStack) {
    }

    @Nullable
    public IRecipe getRecipe(@Nonnull ItemStack bookStack) {
        return (IRecipe)new ShapelessOreRecipe(new ResourceLocation("inventorygenerators", "book_recipe"), bookStack, new Object[]{Items.field_151122_aG, Items.field_151044_h, Items.field_151044_h, Items.field_151044_h}).setRegistryName("inv_gen_guide");
    }

    static {
        generatorStrings = new String[]{"culinary", "death", "end", "explosive", "frosty", "halitosis", "magmatic", "nether_star", "overclocked", "pink", "potion", "slimey", "survivalist"};
        upgradeStrings = new String[]{"auto_pull_upgrade", "no_effect_upgrade", "speed_upgrade"};
        generators = new Item[]{InitModGenerators.invCulinaryGen, InitModGenerators.invDeathGen, InitModGenerators.invEndGen, InitModGenerators.invExplosiveGen, InitModGenerators.invFrostyGen, InitModGenerators.invHalitosisGen, InitModGenerators.invMagmaticGen, InitModGenerators.invNetherStarGen, InitModGenerators.invOverclockedGen, InitModGenerators.invPinkGen, InitModGenerators.invPotionGen, InitModGenerators.invSlimeyGen, InitModGenerators.invSurvivalistGen};
        upgrades = new Item[]{InitModGenerators.autoPullUpgrade, InitModGenerators.noEffectUpgrade, InitModGenerators.speedUpgrade};
        generatorRecipes = new ShapedOreRecipe[]{new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_1"), InitModGenerators.invCulinaryGen, new Object[]{"WWW", "WPW", "RFR", Character.valueOf('W'), "cropWheat", Character.valueOf('P'), Items.field_151157_am, Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_2"), InitModGenerators.invDeathGen, new Object[]{"BBB", "BSB", "RFR", Character.valueOf('B'), "bone", Character.valueOf('S'), Items.field_151070_bp, Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_3"), InitModGenerators.invExplosiveGen, new Object[]{"GGG", "GTG", "RFR", Character.valueOf('G'), "gunpowder", Character.valueOf('T'), Item.func_150898_a((Block)Blocks.field_150335_W), Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_4"), InitModGenerators.invFrostyGen, new Object[]{"SSS", "SIS", "RFR", Character.valueOf('S'), Items.field_151126_ay, Character.valueOf('I'), Item.func_150898_a((Block)Blocks.field_150432_aD), Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_5"), InitModGenerators.invFurnaceGen, new Object[]{"III", "ISI", "RFR", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), InitModGenerators.invSurvivalistGen, Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), Item.func_150898_a((Block)Blocks.field_150460_al)}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_6"), InitModGenerators.invHalitosisGen, new Object[]{"PPP", "PEP", "RFR", Character.valueOf('P'), Item.func_150898_a((Block)Blocks.field_185767_cT), Character.valueOf('E'), Item.func_150898_a((Block)Blocks.field_185764_cQ), Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_7"), InitModGenerators.invMagmaticGen, new Object[]{"GGG", "GLG", "RFR", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), Items.field_151129_at, Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_8"), InitModGenerators.invNetherStarGen, new Object[]{"WWW", "WNW", "RFR", Character.valueOf('W'), new ItemStack(Items.field_151144_bL, 1, 1).func_77973_b(), Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_9"), InitModGenerators.invOverclockedGen, new Object[]{"LLL", "LGL", "RFR", Character.valueOf('L'), "gemLapis", Character.valueOf('G'), "blockGold", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_10"), InitModGenerators.invPinkGen, new Object[]{"PPP", "PWP", "RFR", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 6).func_77973_b(), Character.valueOf('P'), "dyePink", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_11"), InitModGenerators.invPotionGen, new Object[]{"BBB", "BSB", "RFR", Character.valueOf('B'), Items.field_151072_bj, Character.valueOf('S'), Item.func_150898_a((Block)Blocks.field_150382_bo), Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_12"), InitModGenerators.invSlimeyGen, new Object[]{"SSS", "SBS", "RFR", Character.valueOf('S'), "slimeball", Character.valueOf('B'), "blockSlime", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), InitModGenerators.invFurnaceGen}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_13"), InitModGenerators.invSurvivalistGen, new Object[]{"SSS", "SIS", "RFR", Character.valueOf('S'), "cobblestone", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), Item.func_150898_a((Block)Blocks.field_150460_al)})};
        upgradeRecipes = new ShapedOreRecipe[]{new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_14"), InitModGenerators.autoPullUpgrade, new Object[]{"GHG", "RRR", "RRR", Character.valueOf('H'), Item.func_150898_a((Block)Blocks.field_150438_bZ), Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "dustRedstone"}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_15"), InitModGenerators.noEffectUpgrade, new Object[]{"GBG", "RRR", "RRR", Character.valueOf('B'), Items.field_151069_bo, Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "dustRedstone"}), new ShapedOreRecipe(new ResourceLocation("inventorygenerators", "entry_16"), InitModGenerators.speedUpgrade, new Object[]{"GSG", "RRR", "RRR", Character.valueOf('S'), Items.field_151102_aT, Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "dustRedstone"})};
    }
}

