/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import com.blakebr0.cucumber.helper.NBTHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    @Deprecated
    public static ItemStack to(Object obj) {
        if (obj instanceof Block) {
            return new ItemStack((Block)obj);
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj);
        }
        return StackHelper.getNull();
    }

    @Deprecated
    public static ItemStack to(Object obj, int amount) {
        if (obj instanceof Block) {
            return new ItemStack((Block)obj, amount, 0);
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, amount, 0);
        }
        return StackHelper.getNull();
    }

    @Deprecated
    public static ItemStack to(Object obj, int amount, int meta) {
        if (obj instanceof Block) {
            return new ItemStack((Block)obj, amount, meta);
        }
        if (obj instanceof Item) {
            return new ItemStack((Item)obj, amount, meta);
        }
        return StackHelper.getNull();
    }

    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            if (container && stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return ItemStack.field_190927_a;
        }
        stack.func_190920_e(size);
        return stack;
    }

    public static ItemStack increase(ItemStack stack, int amount) {
        stack.func_190917_f(amount);
        return StackHelper.withSize(stack, stack.func_190916_E(), false);
    }

    public static ItemStack decrease(ItemStack stack, int amount, boolean container) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        stack.func_190918_g(amount);
        return StackHelper.withSize(stack, stack.func_190916_E(), container);
    }

    public static int getPlaceFromList(List<ItemStack> list, ItemStack stack, boolean wildcard) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if ((!stack.func_190926_b() || !list.get(i).func_190926_b()) && !StackHelper.areItemsEqual(stack, list.get(i), wildcard)) continue;
                return i;
            }
        }
        return -1;
    }

    public static ItemStack fromOre(String oreDict, int stackSize) {
        ItemStack item = ItemStack.field_190927_a;
        NonNullList list = OreDictionary.getOres((String)oreDict);
        if (!list.isEmpty()) {
            item = ((ItemStack)list.get(0)).func_77946_l();
            item.func_190920_e(stackSize);
        }
        return item;
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2, boolean wildcard) {
        return !stack1.func_190926_b() && !stack2.func_190926_b() && (stack1.func_77969_a(stack2) || wildcard && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE));
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return StackHelper.areItemsEqual(stack1, stack2, false) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_190926_b() && stack2.func_190926_b()) {
            return true;
        }
        return StackHelper.areStacksEqual(stack1, stack2) && stack1.func_190916_E() + stack2.func_190916_E() <= stack1.func_77976_d();
    }

    public static boolean compareTags(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77942_o()) {
            return true;
        }
        if (stack1.func_77942_o() && !stack2.func_77942_o()) {
            return false;
        }
        Set stack1Keys = stack1.func_77978_p().func_150296_c();
        Set stack2Keys = stack2.func_77978_p().func_150296_c();
        for (String key : stack1Keys) {
            if (stack2Keys.contains(key)) {
                if (NBTUtil.func_181123_a((NBTBase)NBTHelper.getTag(stack1, key), (NBTBase)NBTHelper.getTag(stack2, key), (boolean)true)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static EntityItem toEntity(ItemStack stack, World world, double x, double y, double z) {
        return new EntityItem(world, x, y, z, stack);
    }

    @Deprecated
    public static boolean isNull(ItemStack stack) {
        return stack.func_190926_b();
    }

    @Deprecated
    public static ItemStack getNull() {
        return ItemStack.field_190927_a;
    }
}

